/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.ranking.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.ranking.Gs2RankingRestClient;
import io.gs2.ranking.domain.model.ScoreDomain;
import io.gs2.ranking.domain.model.UserDomain;
import io.gs2.ranking.model.Score;
import io.gs2.ranking.request.DescribeScoresByUserIdRequest;
import io.gs2.ranking.result.DescribeScoresByUserIdResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeScoresByUserIdIterator
implements Iterator<Score>,
Iterable<Score> {
    CacheDatabase cache;
    Gs2RankingRestClient client;
    String namespaceName;
    String categoryName;
    String userId;
    String scorerUserId;
    String pageToken;
    boolean last;
    List<Score> result;
    Integer fetchSize;

    public DescribeScoresByUserIdIterator(CacheDatabase cache, Gs2RankingRestClient client, String namespaceName, String categoryName, String userId, String scorerUserId) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.categoryName = categoryName;
        this.userId = userId;
        this.scorerUserId = scorerUserId;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<Score>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Score");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, Score.class)) {
            this.result = this.cache.list(parentKey, Score.class).stream().filter(item -> this.categoryName == null || item.getCategoryName().equals(this.categoryName)).filter(item -> this.scorerUserId == null || item.getScorerUserId().equals(this.scorerUserId)).collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeScoresByUserIdResult r = this.client.describeScoresByUserId(new DescribeScoresByUserIdRequest().withNamespaceName(this.namespaceName).withCategoryName(this.categoryName).withUserId(this.userId).withScorerUserId(this.scorerUserId).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (Score item2 : this.result) {
                this.cache.put(parentKey, ScoreDomain.createCacheKey(item2.getCategoryName() != null ? item2.getCategoryName().toString() : null, item2.getScorerUserId() != null ? item2.getScorerUserId().toString() : null, item2.getUniqueId() != null ? item2.getUniqueId().toString() : null), item2, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, Score.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public Score next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        Score ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<Score> iterator() {
        return this;
    }
}

