/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.ranking.domain.iterator;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.ranking.Gs2RankingRestClient;
import io.gs2.ranking.domain.model.RankingDomain;
import io.gs2.ranking.domain.model.UserDomain;
import io.gs2.ranking.model.Ranking;
import io.gs2.ranking.request.DescribeRankingsRequest;
import io.gs2.ranking.result.DescribeRankingsResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeRankingsIterator
implements Iterator<Ranking>,
Iterable<Ranking> {
    CacheDatabase cache;
    Gs2RankingRestClient client;
    String namespaceName;
    String categoryName;
    AccessToken accessToken;
    String pageToken;
    boolean last;
    List<Ranking> result;
    Integer fetchSize;

    public DescribeRankingsIterator(CacheDatabase cache, Gs2RankingRestClient client, String namespaceName, String categoryName, AccessToken accessToken) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.categoryName = categoryName;
        this.accessToken = accessToken;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<Ranking>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "Singleton", "Ranking");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, Ranking.class)) {
            this.result = this.cache.list(listParentKey, Ranking.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeRankingsResult r = this.client.describeRankings(new DescribeRankingsRequest().withNamespaceName(this.namespaceName).withCategoryName(this.categoryName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (Ranking item : this.result) {
                this.cache.put(listParentKey, RankingDomain.createCacheKey(this.categoryName != null ? this.categoryName.toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, Ranking.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public Ranking next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        Ranking ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<Ranking> iterator() {
        return this;
    }
}

