/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.ranking;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.AbstractGs2Client;
import io.gs2.core.model.AsyncAction;
import io.gs2.core.model.AsyncResult;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2RestSessionTask;
import io.gs2.core.net.HttpTask;
import io.gs2.core.util.EncodingUtil;
import io.gs2.ranking.request.CalcRankingRequest;
import io.gs2.ranking.request.CreateCategoryModelMasterRequest;
import io.gs2.ranking.request.CreateNamespaceRequest;
import io.gs2.ranking.request.DeleteCategoryModelMasterRequest;
import io.gs2.ranking.request.DeleteNamespaceRequest;
import io.gs2.ranking.request.DescribeCategoryModelMastersRequest;
import io.gs2.ranking.request.DescribeCategoryModelsRequest;
import io.gs2.ranking.request.DescribeNamespacesRequest;
import io.gs2.ranking.request.DescribeNearRankingsRequest;
import io.gs2.ranking.request.DescribeRankingsRequest;
import io.gs2.ranking.request.DescribeRankingssByUserIdRequest;
import io.gs2.ranking.request.DescribeScoresByUserIdRequest;
import io.gs2.ranking.request.DescribeScoresRequest;
import io.gs2.ranking.request.DescribeSubscribesByCategoryNameAndUserIdRequest;
import io.gs2.ranking.request.DescribeSubscribesByCategoryNameRequest;
import io.gs2.ranking.request.ExportMasterRequest;
import io.gs2.ranking.request.GetCategoryModelMasterRequest;
import io.gs2.ranking.request.GetCategoryModelRequest;
import io.gs2.ranking.request.GetCurrentRankingMasterRequest;
import io.gs2.ranking.request.GetNamespaceRequest;
import io.gs2.ranking.request.GetNamespaceStatusRequest;
import io.gs2.ranking.request.GetRankingByUserIdRequest;
import io.gs2.ranking.request.GetRankingRequest;
import io.gs2.ranking.request.GetScoreByUserIdRequest;
import io.gs2.ranking.request.GetScoreRequest;
import io.gs2.ranking.request.GetSubscribeByUserIdRequest;
import io.gs2.ranking.request.GetSubscribeRequest;
import io.gs2.ranking.request.PutScoreByUserIdRequest;
import io.gs2.ranking.request.PutScoreRequest;
import io.gs2.ranking.request.SubscribeByUserIdRequest;
import io.gs2.ranking.request.SubscribeRequest;
import io.gs2.ranking.request.UnsubscribeByUserIdRequest;
import io.gs2.ranking.request.UnsubscribeRequest;
import io.gs2.ranking.request.UpdateCategoryModelMasterRequest;
import io.gs2.ranking.request.UpdateCurrentRankingMasterFromGitHubRequest;
import io.gs2.ranking.request.UpdateCurrentRankingMasterRequest;
import io.gs2.ranking.request.UpdateNamespaceRequest;
import io.gs2.ranking.result.CalcRankingResult;
import io.gs2.ranking.result.CreateCategoryModelMasterResult;
import io.gs2.ranking.result.CreateNamespaceResult;
import io.gs2.ranking.result.DeleteCategoryModelMasterResult;
import io.gs2.ranking.result.DeleteNamespaceResult;
import io.gs2.ranking.result.DescribeCategoryModelMastersResult;
import io.gs2.ranking.result.DescribeCategoryModelsResult;
import io.gs2.ranking.result.DescribeNamespacesResult;
import io.gs2.ranking.result.DescribeNearRankingsResult;
import io.gs2.ranking.result.DescribeRankingsResult;
import io.gs2.ranking.result.DescribeRankingssByUserIdResult;
import io.gs2.ranking.result.DescribeScoresByUserIdResult;
import io.gs2.ranking.result.DescribeScoresResult;
import io.gs2.ranking.result.DescribeSubscribesByCategoryNameAndUserIdResult;
import io.gs2.ranking.result.DescribeSubscribesByCategoryNameResult;
import io.gs2.ranking.result.ExportMasterResult;
import io.gs2.ranking.result.GetCategoryModelMasterResult;
import io.gs2.ranking.result.GetCategoryModelResult;
import io.gs2.ranking.result.GetCurrentRankingMasterResult;
import io.gs2.ranking.result.GetNamespaceResult;
import io.gs2.ranking.result.GetNamespaceStatusResult;
import io.gs2.ranking.result.GetRankingByUserIdResult;
import io.gs2.ranking.result.GetRankingResult;
import io.gs2.ranking.result.GetScoreByUserIdResult;
import io.gs2.ranking.result.GetScoreResult;
import io.gs2.ranking.result.GetSubscribeByUserIdResult;
import io.gs2.ranking.result.GetSubscribeResult;
import io.gs2.ranking.result.PutScoreByUserIdResult;
import io.gs2.ranking.result.PutScoreResult;
import io.gs2.ranking.result.SubscribeByUserIdResult;
import io.gs2.ranking.result.SubscribeResult;
import io.gs2.ranking.result.UnsubscribeByUserIdResult;
import io.gs2.ranking.result.UnsubscribeResult;
import io.gs2.ranking.result.UpdateCategoryModelMasterResult;
import io.gs2.ranking.result.UpdateCurrentRankingMasterFromGitHubResult;
import io.gs2.ranking.result.UpdateCurrentRankingMasterResult;
import io.gs2.ranking.result.UpdateNamespaceResult;
import java.util.ArrayList;
import java.util.HashMap;

public class Gs2RankingRestClient
extends AbstractGs2Client<Gs2RankingRestClient> {
    public Gs2RankingRestClient(Gs2RestSession gs2RestSession) {
        super(gs2RestSession);
    }

    public void describeNamespacesAsync(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> callback) {
        DescribeNamespacesTask task = new DescribeNamespacesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeNamespacesResult describeNamespaces(DescribeNamespacesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeNamespacesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeNamespacesResult)resultAsyncResult[0].getResult();
    }

    public void createNamespaceAsync(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> callback) {
        CreateNamespaceTask task = new CreateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public CreateNamespaceResult createNamespace(CreateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceStatusAsync(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> callback) {
        GetNamespaceStatusTask task = new GetNamespaceStatusTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceStatusResult getNamespaceStatus(GetNamespaceStatusRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceStatusAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceStatusResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceAsync(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> callback) {
        GetNamespaceTask task = new GetNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceResult getNamespace(GetNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void updateNamespaceAsync(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> callback) {
        UpdateNamespaceTask task = new UpdateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public UpdateNamespaceResult updateNamespace(UpdateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void deleteNamespaceAsync(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> callback) {
        DeleteNamespaceTask task = new DeleteNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void describeCategoryModelsAsync(DescribeCategoryModelsRequest request, AsyncAction<AsyncResult<DescribeCategoryModelsResult>> callback) {
        DescribeCategoryModelsTask task = new DescribeCategoryModelsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeCategoryModelsResult describeCategoryModels(DescribeCategoryModelsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeCategoryModelsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeCategoryModelsResult)resultAsyncResult[0].getResult();
    }

    public void getCategoryModelAsync(GetCategoryModelRequest request, AsyncAction<AsyncResult<GetCategoryModelResult>> callback) {
        GetCategoryModelTask task = new GetCategoryModelTask(request, callback);
        this.session.execute(task);
    }

    public GetCategoryModelResult getCategoryModel(GetCategoryModelRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getCategoryModelAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetCategoryModelResult)resultAsyncResult[0].getResult();
    }

    public void describeCategoryModelMastersAsync(DescribeCategoryModelMastersRequest request, AsyncAction<AsyncResult<DescribeCategoryModelMastersResult>> callback) {
        DescribeCategoryModelMastersTask task = new DescribeCategoryModelMastersTask(request, callback);
        this.session.execute(task);
    }

    public DescribeCategoryModelMastersResult describeCategoryModelMasters(DescribeCategoryModelMastersRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeCategoryModelMastersAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeCategoryModelMastersResult)resultAsyncResult[0].getResult();
    }

    public void createCategoryModelMasterAsync(CreateCategoryModelMasterRequest request, AsyncAction<AsyncResult<CreateCategoryModelMasterResult>> callback) {
        CreateCategoryModelMasterTask task = new CreateCategoryModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public CreateCategoryModelMasterResult createCategoryModelMaster(CreateCategoryModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createCategoryModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateCategoryModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void getCategoryModelMasterAsync(GetCategoryModelMasterRequest request, AsyncAction<AsyncResult<GetCategoryModelMasterResult>> callback) {
        GetCategoryModelMasterTask task = new GetCategoryModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetCategoryModelMasterResult getCategoryModelMaster(GetCategoryModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getCategoryModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetCategoryModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCategoryModelMasterAsync(UpdateCategoryModelMasterRequest request, AsyncAction<AsyncResult<UpdateCategoryModelMasterResult>> callback) {
        UpdateCategoryModelMasterTask task = new UpdateCategoryModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCategoryModelMasterResult updateCategoryModelMaster(UpdateCategoryModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCategoryModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCategoryModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void deleteCategoryModelMasterAsync(DeleteCategoryModelMasterRequest request, AsyncAction<AsyncResult<DeleteCategoryModelMasterResult>> callback) {
        DeleteCategoryModelMasterTask task = new DeleteCategoryModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public DeleteCategoryModelMasterResult deleteCategoryModelMaster(DeleteCategoryModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteCategoryModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteCategoryModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void subscribeAsync(SubscribeRequest request, AsyncAction<AsyncResult<SubscribeResult>> callback) {
        SubscribeTask task = new SubscribeTask(request, callback);
        this.session.execute(task);
    }

    public SubscribeResult subscribe(SubscribeRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.subscribeAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (SubscribeResult)resultAsyncResult[0].getResult();
    }

    public void subscribeByUserIdAsync(SubscribeByUserIdRequest request, AsyncAction<AsyncResult<SubscribeByUserIdResult>> callback) {
        SubscribeByUserIdTask task = new SubscribeByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public SubscribeByUserIdResult subscribeByUserId(SubscribeByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.subscribeByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (SubscribeByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void describeScoresAsync(DescribeScoresRequest request, AsyncAction<AsyncResult<DescribeScoresResult>> callback) {
        DescribeScoresTask task = new DescribeScoresTask(request, callback);
        this.session.execute(task);
    }

    public DescribeScoresResult describeScores(DescribeScoresRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeScoresAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeScoresResult)resultAsyncResult[0].getResult();
    }

    public void describeScoresByUserIdAsync(DescribeScoresByUserIdRequest request, AsyncAction<AsyncResult<DescribeScoresByUserIdResult>> callback) {
        DescribeScoresByUserIdTask task = new DescribeScoresByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DescribeScoresByUserIdResult describeScoresByUserId(DescribeScoresByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeScoresByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeScoresByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void getScoreAsync(GetScoreRequest request, AsyncAction<AsyncResult<GetScoreResult>> callback) {
        GetScoreTask task = new GetScoreTask(request, callback);
        this.session.execute(task);
    }

    public GetScoreResult getScore(GetScoreRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getScoreAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetScoreResult)resultAsyncResult[0].getResult();
    }

    public void getScoreByUserIdAsync(GetScoreByUserIdRequest request, AsyncAction<AsyncResult<GetScoreByUserIdResult>> callback) {
        GetScoreByUserIdTask task = new GetScoreByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetScoreByUserIdResult getScoreByUserId(GetScoreByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getScoreByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetScoreByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void describeRankingsAsync(DescribeRankingsRequest request, AsyncAction<AsyncResult<DescribeRankingsResult>> callback) {
        DescribeRankingsTask task = new DescribeRankingsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeRankingsResult describeRankings(DescribeRankingsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeRankingsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeRankingsResult)resultAsyncResult[0].getResult();
    }

    public void describeRankingssByUserIdAsync(DescribeRankingssByUserIdRequest request, AsyncAction<AsyncResult<DescribeRankingssByUserIdResult>> callback) {
        DescribeRankingssByUserIdTask task = new DescribeRankingssByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DescribeRankingssByUserIdResult describeRankingssByUserId(DescribeRankingssByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeRankingssByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeRankingssByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void describeNearRankingsAsync(DescribeNearRankingsRequest request, AsyncAction<AsyncResult<DescribeNearRankingsResult>> callback) {
        DescribeNearRankingsTask task = new DescribeNearRankingsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeNearRankingsResult describeNearRankings(DescribeNearRankingsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeNearRankingsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeNearRankingsResult)resultAsyncResult[0].getResult();
    }

    public void getRankingAsync(GetRankingRequest request, AsyncAction<AsyncResult<GetRankingResult>> callback) {
        GetRankingTask task = new GetRankingTask(request, callback);
        this.session.execute(task);
    }

    public GetRankingResult getRanking(GetRankingRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getRankingAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetRankingResult)resultAsyncResult[0].getResult();
    }

    public void getRankingByUserIdAsync(GetRankingByUserIdRequest request, AsyncAction<AsyncResult<GetRankingByUserIdResult>> callback) {
        GetRankingByUserIdTask task = new GetRankingByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetRankingByUserIdResult getRankingByUserId(GetRankingByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getRankingByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetRankingByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void putScoreAsync(PutScoreRequest request, AsyncAction<AsyncResult<PutScoreResult>> callback) {
        PutScoreTask task = new PutScoreTask(request, callback);
        this.session.execute(task);
    }

    public PutScoreResult putScore(PutScoreRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.putScoreAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (PutScoreResult)resultAsyncResult[0].getResult();
    }

    public void putScoreByUserIdAsync(PutScoreByUserIdRequest request, AsyncAction<AsyncResult<PutScoreByUserIdResult>> callback) {
        PutScoreByUserIdTask task = new PutScoreByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public PutScoreByUserIdResult putScoreByUserId(PutScoreByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.putScoreByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (PutScoreByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void calcRankingAsync(CalcRankingRequest request, AsyncAction<AsyncResult<CalcRankingResult>> callback) {
        CalcRankingTask task = new CalcRankingTask(request, callback);
        this.session.execute(task);
    }

    public CalcRankingResult calcRanking(CalcRankingRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.calcRankingAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CalcRankingResult)resultAsyncResult[0].getResult();
    }

    public void exportMasterAsync(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> callback) {
        ExportMasterTask task = new ExportMasterTask(request, callback);
        this.session.execute(task);
    }

    public ExportMasterResult exportMaster(ExportMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.exportMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ExportMasterResult)resultAsyncResult[0].getResult();
    }

    public void getCurrentRankingMasterAsync(GetCurrentRankingMasterRequest request, AsyncAction<AsyncResult<GetCurrentRankingMasterResult>> callback) {
        GetCurrentRankingMasterTask task = new GetCurrentRankingMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetCurrentRankingMasterResult getCurrentRankingMaster(GetCurrentRankingMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getCurrentRankingMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetCurrentRankingMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentRankingMasterAsync(UpdateCurrentRankingMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentRankingMasterResult>> callback) {
        UpdateCurrentRankingMasterTask task = new UpdateCurrentRankingMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentRankingMasterResult updateCurrentRankingMaster(UpdateCurrentRankingMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentRankingMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentRankingMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentRankingMasterFromGitHubAsync(UpdateCurrentRankingMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentRankingMasterFromGitHubResult>> callback) {
        UpdateCurrentRankingMasterFromGitHubTask task = new UpdateCurrentRankingMasterFromGitHubTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentRankingMasterFromGitHubResult updateCurrentRankingMasterFromGitHub(UpdateCurrentRankingMasterFromGitHubRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentRankingMasterFromGitHubAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentRankingMasterFromGitHubResult)resultAsyncResult[0].getResult();
    }

    public void getSubscribeAsync(GetSubscribeRequest request, AsyncAction<AsyncResult<GetSubscribeResult>> callback) {
        GetSubscribeTask task = new GetSubscribeTask(request, callback);
        this.session.execute(task);
    }

    public GetSubscribeResult getSubscribe(GetSubscribeRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getSubscribeAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetSubscribeResult)resultAsyncResult[0].getResult();
    }

    public void getSubscribeByUserIdAsync(GetSubscribeByUserIdRequest request, AsyncAction<AsyncResult<GetSubscribeByUserIdResult>> callback) {
        GetSubscribeByUserIdTask task = new GetSubscribeByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetSubscribeByUserIdResult getSubscribeByUserId(GetSubscribeByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getSubscribeByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetSubscribeByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void unsubscribeAsync(UnsubscribeRequest request, AsyncAction<AsyncResult<UnsubscribeResult>> callback) {
        UnsubscribeTask task = new UnsubscribeTask(request, callback);
        this.session.execute(task);
    }

    public UnsubscribeResult unsubscribe(UnsubscribeRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.unsubscribeAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UnsubscribeResult)resultAsyncResult[0].getResult();
    }

    public void unsubscribeByUserIdAsync(UnsubscribeByUserIdRequest request, AsyncAction<AsyncResult<UnsubscribeByUserIdResult>> callback) {
        UnsubscribeByUserIdTask task = new UnsubscribeByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public UnsubscribeByUserIdResult unsubscribeByUserId(UnsubscribeByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.unsubscribeByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UnsubscribeByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void describeSubscribesByCategoryNameAsync(DescribeSubscribesByCategoryNameRequest request, AsyncAction<AsyncResult<DescribeSubscribesByCategoryNameResult>> callback) {
        DescribeSubscribesByCategoryNameTask task = new DescribeSubscribesByCategoryNameTask(request, callback);
        this.session.execute(task);
    }

    public DescribeSubscribesByCategoryNameResult describeSubscribesByCategoryName(DescribeSubscribesByCategoryNameRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeSubscribesByCategoryNameAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeSubscribesByCategoryNameResult)resultAsyncResult[0].getResult();
    }

    public void describeSubscribesByCategoryNameAndUserIdAsync(DescribeSubscribesByCategoryNameAndUserIdRequest request, AsyncAction<AsyncResult<DescribeSubscribesByCategoryNameAndUserIdResult>> callback) {
        DescribeSubscribesByCategoryNameAndUserIdTask task = new DescribeSubscribesByCategoryNameAndUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DescribeSubscribesByCategoryNameAndUserIdResult describeSubscribesByCategoryNameAndUserId(DescribeSubscribesByCategoryNameAndUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeSubscribesByCategoryNameAndUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeSubscribesByCategoryNameAndUserIdResult)resultAsyncResult[0].getResult();
    }

    class DescribeSubscribesByCategoryNameAndUserIdTask
    extends Gs2RestSessionTask<DescribeSubscribesByCategoryNameAndUserIdResult> {
        private DescribeSubscribesByCategoryNameAndUserIdRequest request;

        public DescribeSubscribesByCategoryNameAndUserIdTask(DescribeSubscribesByCategoryNameAndUserIdRequest request, AsyncAction<AsyncResult<DescribeSubscribesByCategoryNameAndUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2RankingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeSubscribesByCategoryNameAndUserIdResult parse(JsonNode data) {
            return DescribeSubscribesByCategoryNameAndUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ranking").replace("{region}", Gs2RankingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/subscribe/category/{categoryName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{categoryName}", this.request.getCategoryName() == null || this.request.getCategoryName().length() == 0 ? "null" : String.valueOf(this.request.getCategoryName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeSubscribesByCategoryNameTask
    extends Gs2RestSessionTask<DescribeSubscribesByCategoryNameResult> {
        private DescribeSubscribesByCategoryNameRequest request;

        public DescribeSubscribesByCategoryNameTask(DescribeSubscribesByCategoryNameRequest request, AsyncAction<AsyncResult<DescribeSubscribesByCategoryNameResult>> userCallback) {
            super((Gs2RestSession)Gs2RankingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeSubscribesByCategoryNameResult parse(JsonNode data) {
            return DescribeSubscribesByCategoryNameResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ranking").replace("{region}", Gs2RankingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/subscribe/category/{categoryName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{categoryName}", this.request.getCategoryName() == null || this.request.getCategoryName().length() == 0 ? "null" : String.valueOf(this.request.getCategoryName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class UnsubscribeByUserIdTask
    extends Gs2RestSessionTask<UnsubscribeByUserIdResult> {
        private UnsubscribeByUserIdRequest request;

        public UnsubscribeByUserIdTask(UnsubscribeByUserIdRequest request, AsyncAction<AsyncResult<UnsubscribeByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2RankingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UnsubscribeByUserIdResult parse(JsonNode data) {
            return UnsubscribeByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ranking").replace("{region}", Gs2RankingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/subscribe/category/{categoryName}/target/{targetUserId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{categoryName}", this.request.getCategoryName() == null || this.request.getCategoryName().length() == 0 ? "null" : String.valueOf(this.request.getCategoryName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{targetUserId}", this.request.getTargetUserId() == null || this.request.getTargetUserId().length() == 0 ? "null" : String.valueOf(this.request.getTargetUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UnsubscribeTask
    extends Gs2RestSessionTask<UnsubscribeResult> {
        private UnsubscribeRequest request;

        public UnsubscribeTask(UnsubscribeRequest request, AsyncAction<AsyncResult<UnsubscribeResult>> userCallback) {
            super((Gs2RestSession)Gs2RankingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UnsubscribeResult parse(JsonNode data) {
            return UnsubscribeResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ranking").replace("{region}", Gs2RankingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/subscribe/category/{categoryName}/target/{targetUserId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{categoryName}", this.request.getCategoryName() == null || this.request.getCategoryName().length() == 0 ? "null" : String.valueOf(this.request.getCategoryName()));
            url = url.replace("{targetUserId}", this.request.getTargetUserId() == null || this.request.getTargetUserId().length() == 0 ? "null" : String.valueOf(this.request.getTargetUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class GetSubscribeByUserIdTask
    extends Gs2RestSessionTask<GetSubscribeByUserIdResult> {
        private GetSubscribeByUserIdRequest request;

        public GetSubscribeByUserIdTask(GetSubscribeByUserIdRequest request, AsyncAction<AsyncResult<GetSubscribeByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2RankingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetSubscribeByUserIdResult parse(JsonNode data) {
            return GetSubscribeByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ranking").replace("{region}", Gs2RankingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/subscribe/category/{categoryName}/target/{targetUserId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{categoryName}", this.request.getCategoryName() == null || this.request.getCategoryName().length() == 0 ? "null" : String.valueOf(this.request.getCategoryName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{targetUserId}", this.request.getTargetUserId() == null || this.request.getTargetUserId().length() == 0 ? "null" : String.valueOf(this.request.getTargetUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetSubscribeTask
    extends Gs2RestSessionTask<GetSubscribeResult> {
        private GetSubscribeRequest request;

        public GetSubscribeTask(GetSubscribeRequest request, AsyncAction<AsyncResult<GetSubscribeResult>> userCallback) {
            super((Gs2RestSession)Gs2RankingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetSubscribeResult parse(JsonNode data) {
            return GetSubscribeResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ranking").replace("{region}", Gs2RankingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/subscribe/category/{categoryName}/target/{targetUserId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{categoryName}", this.request.getCategoryName() == null || this.request.getCategoryName().length() == 0 ? "null" : String.valueOf(this.request.getCategoryName()));
            url = url.replace("{targetUserId}", this.request.getTargetUserId() == null || this.request.getTargetUserId().length() == 0 ? "null" : String.valueOf(this.request.getTargetUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentRankingMasterFromGitHubTask
    extends Gs2RestSessionTask<UpdateCurrentRankingMasterFromGitHubResult> {
        private UpdateCurrentRankingMasterFromGitHubRequest request;

        public UpdateCurrentRankingMasterFromGitHubTask(UpdateCurrentRankingMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentRankingMasterFromGitHubResult>> userCallback) {
            super((Gs2RestSession)Gs2RankingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentRankingMasterFromGitHubResult parse(JsonNode data) {
            return UpdateCurrentRankingMasterFromGitHubResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ranking").replace("{region}", Gs2RankingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/from_git_hub";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("checkoutSetting", UpdateCurrentRankingMasterFromGitHubTask.this.request.getCheckoutSetting() != null ? UpdateCurrentRankingMasterFromGitHubTask.this.request.getCheckoutSetting().toJson() : null);
                    this.put("contextStack", UpdateCurrentRankingMasterFromGitHubTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentRankingMasterTask
    extends Gs2RestSessionTask<UpdateCurrentRankingMasterResult> {
        private UpdateCurrentRankingMasterRequest request;

        public UpdateCurrentRankingMasterTask(UpdateCurrentRankingMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentRankingMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2RankingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentRankingMasterResult parse(JsonNode data) {
            return UpdateCurrentRankingMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ranking").replace("{region}", Gs2RankingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("settings", UpdateCurrentRankingMasterTask.this.request.getSettings());
                    this.put("contextStack", UpdateCurrentRankingMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetCurrentRankingMasterTask
    extends Gs2RestSessionTask<GetCurrentRankingMasterResult> {
        private GetCurrentRankingMasterRequest request;

        public GetCurrentRankingMasterTask(GetCurrentRankingMasterRequest request, AsyncAction<AsyncResult<GetCurrentRankingMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2RankingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetCurrentRankingMasterResult parse(JsonNode data) {
            return GetCurrentRankingMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ranking").replace("{region}", Gs2RankingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class ExportMasterTask
    extends Gs2RestSessionTask<ExportMasterResult> {
        private ExportMasterRequest request;

        public ExportMasterTask(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2RankingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ExportMasterResult parse(JsonNode data) {
            return ExportMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ranking").replace("{region}", Gs2RankingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/export";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CalcRankingTask
    extends Gs2RestSessionTask<CalcRankingResult> {
        private CalcRankingRequest request;

        public CalcRankingTask(CalcRankingRequest request, AsyncAction<AsyncResult<CalcRankingResult>> userCallback) {
            super((Gs2RestSession)Gs2RankingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CalcRankingResult parse(JsonNode data) {
            return CalcRankingResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ranking").replace("{region}", Gs2RankingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/category/{categoryName}/calc/ranking";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{categoryName}", this.request.getCategoryName() == null || this.request.getCategoryName().length() == 0 ? "null" : String.valueOf(this.request.getCategoryName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", CalcRankingTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class PutScoreByUserIdTask
    extends Gs2RestSessionTask<PutScoreByUserIdResult> {
        private PutScoreByUserIdRequest request;

        public PutScoreByUserIdTask(PutScoreByUserIdRequest request, AsyncAction<AsyncResult<PutScoreByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2RankingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public PutScoreByUserIdResult parse(JsonNode data) {
            return PutScoreByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ranking").replace("{region}", Gs2RankingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/category/{categoryName}/ranking";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{categoryName}", this.request.getCategoryName() == null || this.request.getCategoryName().length() == 0 ? "null" : String.valueOf(this.request.getCategoryName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("score", PutScoreByUserIdTask.this.request.getScore());
                    this.put("metadata", PutScoreByUserIdTask.this.request.getMetadata());
                    this.put("contextStack", PutScoreByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class PutScoreTask
    extends Gs2RestSessionTask<PutScoreResult> {
        private PutScoreRequest request;

        public PutScoreTask(PutScoreRequest request, AsyncAction<AsyncResult<PutScoreResult>> userCallback) {
            super((Gs2RestSession)Gs2RankingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public PutScoreResult parse(JsonNode data) {
            return PutScoreResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ranking").replace("{region}", Gs2RankingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/category/{categoryName}/ranking";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{categoryName}", this.request.getCategoryName() == null || this.request.getCategoryName().length() == 0 ? "null" : String.valueOf(this.request.getCategoryName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("score", PutScoreTask.this.request.getScore());
                    this.put("metadata", PutScoreTask.this.request.getMetadata());
                    this.put("contextStack", PutScoreTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class GetRankingByUserIdTask
    extends Gs2RestSessionTask<GetRankingByUserIdResult> {
        private GetRankingByUserIdRequest request;

        public GetRankingByUserIdTask(GetRankingByUserIdRequest request, AsyncAction<AsyncResult<GetRankingByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2RankingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetRankingByUserIdResult parse(JsonNode data) {
            return GetRankingByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ranking").replace("{region}", Gs2RankingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/category/{categoryName}/ranking/scorer/{scorerUserId}/score/{uniqueId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{categoryName}", this.request.getCategoryName() == null || this.request.getCategoryName().length() == 0 ? "null" : String.valueOf(this.request.getCategoryName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{scorerUserId}", this.request.getScorerUserId() == null || this.request.getScorerUserId().length() == 0 ? "null" : String.valueOf(this.request.getScorerUserId()));
            url = url.replace("{uniqueId}", this.request.getUniqueId() == null || this.request.getUniqueId().length() == 0 ? "null" : String.valueOf(this.request.getUniqueId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetRankingTask
    extends Gs2RestSessionTask<GetRankingResult> {
        private GetRankingRequest request;

        public GetRankingTask(GetRankingRequest request, AsyncAction<AsyncResult<GetRankingResult>> userCallback) {
            super((Gs2RestSession)Gs2RankingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetRankingResult parse(JsonNode data) {
            return GetRankingResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ranking").replace("{region}", Gs2RankingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/category/{categoryName}/ranking/scorer/{scorerUserId}/score/{uniqueId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{categoryName}", this.request.getCategoryName() == null || this.request.getCategoryName().length() == 0 ? "null" : String.valueOf(this.request.getCategoryName()));
            url = url.replace("{scorerUserId}", this.request.getScorerUserId() == null || this.request.getScorerUserId().length() == 0 ? "null" : String.valueOf(this.request.getScorerUserId()));
            url = url.replace("{uniqueId}", this.request.getUniqueId() == null || this.request.getUniqueId().length() == 0 ? "null" : String.valueOf(this.request.getUniqueId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DescribeNearRankingsTask
    extends Gs2RestSessionTask<DescribeNearRankingsResult> {
        private DescribeNearRankingsRequest request;

        public DescribeNearRankingsTask(DescribeNearRankingsRequest request, AsyncAction<AsyncResult<DescribeNearRankingsResult>> userCallback) {
            super((Gs2RestSession)Gs2RankingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeNearRankingsResult parse(JsonNode data) {
            return DescribeNearRankingsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ranking").replace("{region}", Gs2RankingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/category/{categoryName}/ranking/near";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{categoryName}", this.request.getCategoryName() == null || this.request.getCategoryName().length() == 0 ? "null" : String.valueOf(this.request.getCategoryName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getScore() != null) {
                queryStrings.add("score=" + String.valueOf(this.request.getScore()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeRankingssByUserIdTask
    extends Gs2RestSessionTask<DescribeRankingssByUserIdResult> {
        private DescribeRankingssByUserIdRequest request;

        public DescribeRankingssByUserIdTask(DescribeRankingssByUserIdRequest request, AsyncAction<AsyncResult<DescribeRankingssByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2RankingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeRankingssByUserIdResult parse(JsonNode data) {
            return DescribeRankingssByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ranking").replace("{region}", Gs2RankingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/category/{categoryName}/ranking";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{categoryName}", this.request.getCategoryName() == null || this.request.getCategoryName().length() == 0 ? "null" : String.valueOf(this.request.getCategoryName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getStartIndex() != null) {
                queryStrings.add("startIndex=" + String.valueOf(this.request.getStartIndex()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeRankingsTask
    extends Gs2RestSessionTask<DescribeRankingsResult> {
        private DescribeRankingsRequest request;

        public DescribeRankingsTask(DescribeRankingsRequest request, AsyncAction<AsyncResult<DescribeRankingsResult>> userCallback) {
            super((Gs2RestSession)Gs2RankingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeRankingsResult parse(JsonNode data) {
            return DescribeRankingsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ranking").replace("{region}", Gs2RankingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/category/{categoryName}/ranking";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{categoryName}", this.request.getCategoryName() == null || this.request.getCategoryName().length() == 0 ? "null" : String.valueOf(this.request.getCategoryName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getStartIndex() != null) {
                queryStrings.add("startIndex=" + String.valueOf(this.request.getStartIndex()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class GetScoreByUserIdTask
    extends Gs2RestSessionTask<GetScoreByUserIdResult> {
        private GetScoreByUserIdRequest request;

        public GetScoreByUserIdTask(GetScoreByUserIdRequest request, AsyncAction<AsyncResult<GetScoreByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2RankingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetScoreByUserIdResult parse(JsonNode data) {
            return GetScoreByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ranking").replace("{region}", Gs2RankingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/category/{categoryName}/scorer/{scorerUserId}/score/{uniqueId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{categoryName}", this.request.getCategoryName() == null || this.request.getCategoryName().length() == 0 ? "null" : String.valueOf(this.request.getCategoryName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{scorerUserId}", this.request.getScorerUserId() == null || this.request.getScorerUserId().length() == 0 ? "null" : String.valueOf(this.request.getScorerUserId()));
            url = url.replace("{uniqueId}", this.request.getUniqueId() == null || this.request.getUniqueId().length() == 0 ? "null" : String.valueOf(this.request.getUniqueId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetScoreTask
    extends Gs2RestSessionTask<GetScoreResult> {
        private GetScoreRequest request;

        public GetScoreTask(GetScoreRequest request, AsyncAction<AsyncResult<GetScoreResult>> userCallback) {
            super((Gs2RestSession)Gs2RankingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetScoreResult parse(JsonNode data) {
            return GetScoreResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ranking").replace("{region}", Gs2RankingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/category/{categoryName}/scorer/{scorerUserId}/score/{uniqueId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{categoryName}", this.request.getCategoryName() == null || this.request.getCategoryName().length() == 0 ? "null" : String.valueOf(this.request.getCategoryName()));
            url = url.replace("{scorerUserId}", this.request.getScorerUserId() == null || this.request.getScorerUserId().length() == 0 ? "null" : String.valueOf(this.request.getScorerUserId()));
            url = url.replace("{uniqueId}", this.request.getUniqueId() == null || this.request.getUniqueId().length() == 0 ? "null" : String.valueOf(this.request.getUniqueId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DescribeScoresByUserIdTask
    extends Gs2RestSessionTask<DescribeScoresByUserIdResult> {
        private DescribeScoresByUserIdRequest request;

        public DescribeScoresByUserIdTask(DescribeScoresByUserIdRequest request, AsyncAction<AsyncResult<DescribeScoresByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2RankingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeScoresByUserIdResult parse(JsonNode data) {
            return DescribeScoresByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ranking").replace("{region}", Gs2RankingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/category/{categoryName}/scorer/{scorerUserId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{categoryName}", this.request.getCategoryName() == null || this.request.getCategoryName().length() == 0 ? "null" : String.valueOf(this.request.getCategoryName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{scorerUserId}", this.request.getScorerUserId() == null || this.request.getScorerUserId().length() == 0 ? "null" : String.valueOf(this.request.getScorerUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeScoresTask
    extends Gs2RestSessionTask<DescribeScoresResult> {
        private DescribeScoresRequest request;

        public DescribeScoresTask(DescribeScoresRequest request, AsyncAction<AsyncResult<DescribeScoresResult>> userCallback) {
            super((Gs2RestSession)Gs2RankingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeScoresResult parse(JsonNode data) {
            return DescribeScoresResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ranking").replace("{region}", Gs2RankingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/category/{categoryName}/scorer/{scorerUserId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{categoryName}", this.request.getCategoryName() == null || this.request.getCategoryName().length() == 0 ? "null" : String.valueOf(this.request.getCategoryName()));
            url = url.replace("{scorerUserId}", this.request.getScorerUserId() == null || this.request.getScorerUserId().length() == 0 ? "null" : String.valueOf(this.request.getScorerUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class SubscribeByUserIdTask
    extends Gs2RestSessionTask<SubscribeByUserIdResult> {
        private SubscribeByUserIdRequest request;

        public SubscribeByUserIdTask(SubscribeByUserIdRequest request, AsyncAction<AsyncResult<SubscribeByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2RankingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public SubscribeByUserIdResult parse(JsonNode data) {
            return SubscribeByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ranking").replace("{region}", Gs2RankingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/subscribe/category/{categoryName}/target/{targetUserId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{categoryName}", this.request.getCategoryName() == null || this.request.getCategoryName().length() == 0 ? "null" : String.valueOf(this.request.getCategoryName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{targetUserId}", this.request.getTargetUserId() == null || this.request.getTargetUserId().length() == 0 ? "null" : String.valueOf(this.request.getTargetUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", SubscribeByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class SubscribeTask
    extends Gs2RestSessionTask<SubscribeResult> {
        private SubscribeRequest request;

        public SubscribeTask(SubscribeRequest request, AsyncAction<AsyncResult<SubscribeResult>> userCallback) {
            super((Gs2RestSession)Gs2RankingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public SubscribeResult parse(JsonNode data) {
            return SubscribeResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ranking").replace("{region}", Gs2RankingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/subscribe/category/{categoryName}/target/{targetUserId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{categoryName}", this.request.getCategoryName() == null || this.request.getCategoryName().length() == 0 ? "null" : String.valueOf(this.request.getCategoryName()));
            url = url.replace("{targetUserId}", this.request.getTargetUserId() == null || this.request.getTargetUserId().length() == 0 ? "null" : String.valueOf(this.request.getTargetUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", SubscribeTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DeleteCategoryModelMasterTask
    extends Gs2RestSessionTask<DeleteCategoryModelMasterResult> {
        private DeleteCategoryModelMasterRequest request;

        public DeleteCategoryModelMasterTask(DeleteCategoryModelMasterRequest request, AsyncAction<AsyncResult<DeleteCategoryModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2RankingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteCategoryModelMasterResult parse(JsonNode data) {
            return DeleteCategoryModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ranking").replace("{region}", Gs2RankingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/category/{categoryName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{categoryName}", this.request.getCategoryName() == null || this.request.getCategoryName().length() == 0 ? "null" : String.valueOf(this.request.getCategoryName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCategoryModelMasterTask
    extends Gs2RestSessionTask<UpdateCategoryModelMasterResult> {
        private UpdateCategoryModelMasterRequest request;

        public UpdateCategoryModelMasterTask(UpdateCategoryModelMasterRequest request, AsyncAction<AsyncResult<UpdateCategoryModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2RankingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCategoryModelMasterResult parse(JsonNode data) {
            return UpdateCategoryModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ranking").replace("{region}", Gs2RankingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/category/{categoryName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{categoryName}", this.request.getCategoryName() == null || this.request.getCategoryName().length() == 0 ? "null" : String.valueOf(this.request.getCategoryName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateCategoryModelMasterTask.this.request.getDescription());
                    this.put("metadata", UpdateCategoryModelMasterTask.this.request.getMetadata());
                    this.put("minimumValue", UpdateCategoryModelMasterTask.this.request.getMinimumValue());
                    this.put("maximumValue", UpdateCategoryModelMasterTask.this.request.getMaximumValue());
                    this.put("orderDirection", UpdateCategoryModelMasterTask.this.request.getOrderDirection());
                    this.put("scope", UpdateCategoryModelMasterTask.this.request.getScope());
                    this.put("uniqueByUserId", UpdateCategoryModelMasterTask.this.request.getUniqueByUserId());
                    this.put("calculateFixedTimingHour", UpdateCategoryModelMasterTask.this.request.getCalculateFixedTimingHour());
                    this.put("calculateFixedTimingMinute", UpdateCategoryModelMasterTask.this.request.getCalculateFixedTimingMinute());
                    this.put("calculateIntervalMinutes", UpdateCategoryModelMasterTask.this.request.getCalculateIntervalMinutes());
                    this.put("entryPeriodEventId", UpdateCategoryModelMasterTask.this.request.getEntryPeriodEventId());
                    this.put("accessPeriodEventId", UpdateCategoryModelMasterTask.this.request.getAccessPeriodEventId());
                    this.put("generation", UpdateCategoryModelMasterTask.this.request.getGeneration());
                    this.put("contextStack", UpdateCategoryModelMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetCategoryModelMasterTask
    extends Gs2RestSessionTask<GetCategoryModelMasterResult> {
        private GetCategoryModelMasterRequest request;

        public GetCategoryModelMasterTask(GetCategoryModelMasterRequest request, AsyncAction<AsyncResult<GetCategoryModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2RankingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetCategoryModelMasterResult parse(JsonNode data) {
            return GetCategoryModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ranking").replace("{region}", Gs2RankingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/category/{categoryName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{categoryName}", this.request.getCategoryName() == null || this.request.getCategoryName().length() == 0 ? "null" : String.valueOf(this.request.getCategoryName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateCategoryModelMasterTask
    extends Gs2RestSessionTask<CreateCategoryModelMasterResult> {
        private CreateCategoryModelMasterRequest request;

        public CreateCategoryModelMasterTask(CreateCategoryModelMasterRequest request, AsyncAction<AsyncResult<CreateCategoryModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2RankingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateCategoryModelMasterResult parse(JsonNode data) {
            return CreateCategoryModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ranking").replace("{region}", Gs2RankingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/category";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateCategoryModelMasterTask.this.request.getName());
                    this.put("description", CreateCategoryModelMasterTask.this.request.getDescription());
                    this.put("metadata", CreateCategoryModelMasterTask.this.request.getMetadata());
                    this.put("minimumValue", CreateCategoryModelMasterTask.this.request.getMinimumValue());
                    this.put("maximumValue", CreateCategoryModelMasterTask.this.request.getMaximumValue());
                    this.put("orderDirection", CreateCategoryModelMasterTask.this.request.getOrderDirection());
                    this.put("scope", CreateCategoryModelMasterTask.this.request.getScope());
                    this.put("uniqueByUserId", CreateCategoryModelMasterTask.this.request.getUniqueByUserId());
                    this.put("calculateFixedTimingHour", CreateCategoryModelMasterTask.this.request.getCalculateFixedTimingHour());
                    this.put("calculateFixedTimingMinute", CreateCategoryModelMasterTask.this.request.getCalculateFixedTimingMinute());
                    this.put("calculateIntervalMinutes", CreateCategoryModelMasterTask.this.request.getCalculateIntervalMinutes());
                    this.put("entryPeriodEventId", CreateCategoryModelMasterTask.this.request.getEntryPeriodEventId());
                    this.put("accessPeriodEventId", CreateCategoryModelMasterTask.this.request.getAccessPeriodEventId());
                    this.put("generation", CreateCategoryModelMasterTask.this.request.getGeneration());
                    this.put("contextStack", CreateCategoryModelMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeCategoryModelMastersTask
    extends Gs2RestSessionTask<DescribeCategoryModelMastersResult> {
        private DescribeCategoryModelMastersRequest request;

        public DescribeCategoryModelMastersTask(DescribeCategoryModelMastersRequest request, AsyncAction<AsyncResult<DescribeCategoryModelMastersResult>> userCallback) {
            super((Gs2RestSession)Gs2RankingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeCategoryModelMastersResult parse(JsonNode data) {
            return DescribeCategoryModelMastersResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ranking").replace("{region}", Gs2RankingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/category";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetCategoryModelTask
    extends Gs2RestSessionTask<GetCategoryModelResult> {
        private GetCategoryModelRequest request;

        public GetCategoryModelTask(GetCategoryModelRequest request, AsyncAction<AsyncResult<GetCategoryModelResult>> userCallback) {
            super((Gs2RestSession)Gs2RankingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetCategoryModelResult parse(JsonNode data) {
            return GetCategoryModelResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ranking").replace("{region}", Gs2RankingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/category/{categoryName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{categoryName}", this.request.getCategoryName() == null || this.request.getCategoryName().length() == 0 ? "null" : String.valueOf(this.request.getCategoryName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeCategoryModelsTask
    extends Gs2RestSessionTask<DescribeCategoryModelsResult> {
        private DescribeCategoryModelsRequest request;

        public DescribeCategoryModelsTask(DescribeCategoryModelsRequest request, AsyncAction<AsyncResult<DescribeCategoryModelsResult>> userCallback) {
            super((Gs2RestSession)Gs2RankingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeCategoryModelsResult parse(JsonNode data) {
            return DescribeCategoryModelsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ranking").replace("{region}", Gs2RankingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/category";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteNamespaceTask
    extends Gs2RestSessionTask<DeleteNamespaceResult> {
        private DeleteNamespaceRequest request;

        public DeleteNamespaceTask(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2RankingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteNamespaceResult parse(JsonNode data) {
            return DeleteNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ranking").replace("{region}", Gs2RankingRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateNamespaceTask
    extends Gs2RestSessionTask<UpdateNamespaceResult> {
        private UpdateNamespaceRequest request;

        public UpdateNamespaceTask(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2RankingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateNamespaceResult parse(JsonNode data) {
            return UpdateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ranking").replace("{region}", Gs2RankingRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateNamespaceTask.this.request.getDescription());
                    this.put("logSetting", UpdateNamespaceTask.this.request.getLogSetting() != null ? UpdateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", UpdateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceTask
    extends Gs2RestSessionTask<GetNamespaceResult> {
        private GetNamespaceRequest request;

        public GetNamespaceTask(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2RankingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceResult parse(JsonNode data) {
            return GetNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ranking").replace("{region}", Gs2RankingRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceStatusTask
    extends Gs2RestSessionTask<GetNamespaceStatusResult> {
        private GetNamespaceStatusRequest request;

        public GetNamespaceStatusTask(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> userCallback) {
            super((Gs2RestSession)Gs2RankingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceStatusResult parse(JsonNode data) {
            return GetNamespaceStatusResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ranking").replace("{region}", Gs2RankingRestClient.this.session.getRegion().getName()) + "/{namespaceName}/status";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateNamespaceTask
    extends Gs2RestSessionTask<CreateNamespaceResult> {
        private CreateNamespaceRequest request;

        public CreateNamespaceTask(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2RankingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateNamespaceResult parse(JsonNode data) {
            return CreateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ranking").replace("{region}", Gs2RankingRestClient.this.session.getRegion().getName()) + "/";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateNamespaceTask.this.request.getName());
                    this.put("description", CreateNamespaceTask.this.request.getDescription());
                    this.put("logSetting", CreateNamespaceTask.this.request.getLogSetting() != null ? CreateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", CreateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeNamespacesTask
    extends Gs2RestSessionTask<DescribeNamespacesResult> {
        private DescribeNamespacesRequest request;

        public DescribeNamespacesTask(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> userCallback) {
            super((Gs2RestSession)Gs2RankingRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeNamespacesResult parse(JsonNode data) {
            return DescribeNamespacesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ranking").replace("{region}", Gs2RankingRestClient.this.session.getRegion().getName()) + "/";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }
}

