/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.quest.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.model.IModel;
import io.gs2.quest.model.AcquireAction;
import io.gs2.quest.model.ConsumeAction;
import io.gs2.quest.model.Contents;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

@JsonIgnoreProperties(ignoreUnknown=true)
public class QuestModel
implements IModel,
Serializable,
Comparable<QuestModel> {
    private String questModelId;
    private String name;
    private String metadata;
    private List<Contents> contents;
    private String challengePeriodEventId;
    private List<ConsumeAction> consumeActions;
    private List<AcquireAction> failedAcquireActions;
    private List<String> premiseQuestNames;

    public String getQuestModelId() {
        return this.questModelId;
    }

    public void setQuestModelId(String questModelId) {
        this.questModelId = questModelId;
    }

    public QuestModel withQuestModelId(String questModelId) {
        this.questModelId = questModelId;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public QuestModel withName(String name) {
        this.name = name;
        return this;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public QuestModel withMetadata(String metadata) {
        this.metadata = metadata;
        return this;
    }

    public List<Contents> getContents() {
        return this.contents;
    }

    public void setContents(List<Contents> contents) {
        this.contents = contents;
    }

    public QuestModel withContents(List<Contents> contents) {
        this.contents = contents;
        return this;
    }

    public String getChallengePeriodEventId() {
        return this.challengePeriodEventId;
    }

    public void setChallengePeriodEventId(String challengePeriodEventId) {
        this.challengePeriodEventId = challengePeriodEventId;
    }

    public QuestModel withChallengePeriodEventId(String challengePeriodEventId) {
        this.challengePeriodEventId = challengePeriodEventId;
        return this;
    }

    public List<ConsumeAction> getConsumeActions() {
        return this.consumeActions;
    }

    public void setConsumeActions(List<ConsumeAction> consumeActions) {
        this.consumeActions = consumeActions;
    }

    public QuestModel withConsumeActions(List<ConsumeAction> consumeActions) {
        this.consumeActions = consumeActions;
        return this;
    }

    public List<AcquireAction> getFailedAcquireActions() {
        return this.failedAcquireActions;
    }

    public void setFailedAcquireActions(List<AcquireAction> failedAcquireActions) {
        this.failedAcquireActions = failedAcquireActions;
    }

    public QuestModel withFailedAcquireActions(List<AcquireAction> failedAcquireActions) {
        this.failedAcquireActions = failedAcquireActions;
        return this;
    }

    public List<String> getPremiseQuestNames() {
        return this.premiseQuestNames;
    }

    public void setPremiseQuestNames(List<String> premiseQuestNames) {
        this.premiseQuestNames = premiseQuestNames;
    }

    public QuestModel withPremiseQuestNames(List<String> premiseQuestNames) {
        this.premiseQuestNames = premiseQuestNames;
        return this;
    }

    public static QuestModel fromJson(JsonNode data) {
        if (data == null) {
            return null;
        }
        return new QuestModel().withQuestModelId(data.get("questModelId") == null || data.get("questModelId").isNull() ? null : data.get("questModelId").asText()).withName(data.get("name") == null || data.get("name").isNull() ? null : data.get("name").asText()).withMetadata(data.get("metadata") == null || data.get("metadata").isNull() ? null : data.get("metadata").asText()).withContents(data.get("contents") == null || data.get("contents").isNull() ? new ArrayList<Contents>() : StreamSupport.stream(Spliterators.spliteratorUnknownSize(data.get("contents").elements(), 256), false).map(item -> Contents.fromJson(item)).collect(Collectors.toList())).withChallengePeriodEventId(data.get("challengePeriodEventId") == null || data.get("challengePeriodEventId").isNull() ? null : data.get("challengePeriodEventId").asText()).withConsumeActions(data.get("consumeActions") == null || data.get("consumeActions").isNull() ? new ArrayList<ConsumeAction>() : StreamSupport.stream(Spliterators.spliteratorUnknownSize(data.get("consumeActions").elements(), 256), false).map(item -> ConsumeAction.fromJson(item)).collect(Collectors.toList())).withFailedAcquireActions(data.get("failedAcquireActions") == null || data.get("failedAcquireActions").isNull() ? new ArrayList<AcquireAction>() : StreamSupport.stream(Spliterators.spliteratorUnknownSize(data.get("failedAcquireActions").elements(), 256), false).map(item -> AcquireAction.fromJson(item)).collect(Collectors.toList())).withPremiseQuestNames(data.get("premiseQuestNames") == null || data.get("premiseQuestNames").isNull() ? new ArrayList<String>() : StreamSupport.stream(Spliterators.spliteratorUnknownSize(data.get("premiseQuestNames").elements(), 256), false).map(item -> item.asText()).collect(Collectors.toList()));
    }

    public JsonNode toJson() {
        return new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
            {
                this.put("questModelId", QuestModel.this.getQuestModelId());
                this.put("name", QuestModel.this.getName());
                this.put("metadata", QuestModel.this.getMetadata());
                this.put("contents", QuestModel.this.getContents() == null ? new ArrayList() : QuestModel.this.getContents().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                this.put("challengePeriodEventId", QuestModel.this.getChallengePeriodEventId());
                this.put("consumeActions", QuestModel.this.getConsumeActions() == null ? new ArrayList() : QuestModel.this.getConsumeActions().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                this.put("failedAcquireActions", QuestModel.this.getFailedAcquireActions() == null ? new ArrayList() : QuestModel.this.getFailedAcquireActions().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                this.put("premiseQuestNames", QuestModel.this.getPremiseQuestNames() == null ? new ArrayList() : QuestModel.this.getPremiseQuestNames().stream().map(item -> item).collect(Collectors.toList()));
            }
        });
    }

    @Override
    public int compareTo(QuestModel o) {
        return this.questModelId.compareTo(o.questModelId);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.questModelId == null ? 0 : this.questModelId.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = 31 * result + (this.contents == null ? 0 : this.contents.hashCode());
        result = 31 * result + (this.challengePeriodEventId == null ? 0 : this.challengePeriodEventId.hashCode());
        result = 31 * result + (this.consumeActions == null ? 0 : this.consumeActions.hashCode());
        result = 31 * result + (this.failedAcquireActions == null ? 0 : this.failedAcquireActions.hashCode());
        result = 31 * result + (this.premiseQuestNames == null ? 0 : this.premiseQuestNames.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        QuestModel other = (QuestModel)o;
        if (this.questModelId == null) {
            return other.questModelId == null;
        }
        if (!this.questModelId.equals(other.questModelId)) {
            return false;
        }
        if (this.name == null) {
            return other.name == null;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.metadata == null) {
            return other.metadata == null;
        }
        if (!this.metadata.equals(other.metadata)) {
            return false;
        }
        if (this.contents == null) {
            return other.contents == null;
        }
        if (!this.contents.equals(other.contents)) {
            return false;
        }
        if (this.challengePeriodEventId == null) {
            return other.challengePeriodEventId == null;
        }
        if (!this.challengePeriodEventId.equals(other.challengePeriodEventId)) {
            return false;
        }
        if (this.consumeActions == null) {
            return other.consumeActions == null;
        }
        if (!this.consumeActions.equals(other.consumeActions)) {
            return false;
        }
        if (this.failedAcquireActions == null) {
            return other.failedAcquireActions == null;
        }
        if (!this.failedAcquireActions.equals(other.failedAcquireActions)) {
            return false;
        }
        if (this.premiseQuestNames == null) {
            return other.premiseQuestNames == null;
        }
        return this.premiseQuestNames.equals(other.premiseQuestNames);
    }
}

