/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.quest.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.domain.StampSheetDomain;
import io.gs2.core.exception.Gs2Exception;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.exception.TransactionException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.quest.Gs2QuestRestClient;
import io.gs2.quest.domain.iterator.DescribeCompletedQuestListsByUserIdIterator;
import io.gs2.quest.domain.iterator.DescribeProgressesByUserIdIterator;
import io.gs2.quest.domain.model.CompletedQuestListDomain;
import io.gs2.quest.domain.model.NamespaceDomain;
import io.gs2.quest.domain.model.ProgressDomain;
import io.gs2.quest.model.Progress;
import io.gs2.quest.request.CreateProgressByUserIdRequest;
import io.gs2.quest.request.DeleteProgressByUserIdRequest;
import io.gs2.quest.request.StartByUserIdRequest;
import io.gs2.quest.result.CreateProgressByUserIdResult;
import io.gs2.quest.result.DeleteProgressByUserIdResult;
import io.gs2.quest.result.StartByUserIdResult;

public class UserDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2QuestRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String parentKey;
    String nextPageToken;

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public UserDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2QuestRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "User");
    }

    public ProgressDomain createProgress(CreateProgressByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        CreateProgressByUserIdResult result = this.client.createProgressByUserId(request);
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Progress");
        if (result.getItem() != null) {
            this.cache.put(parentKey, ProgressDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        ProgressDomain domain = new ProgressDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getUserId(), result.getItem().getTransactionId());
        return domain;
    }

    public StampSheetDomain start(StartByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        StartByUserIdResult result = this.client.startByUserId(request);
        StampSheetDomain stampSheet = new StampSheetDomain(this.cache, this.jobQueueDomain, this.session, result.getStampSheet(), result.getStampSheetEncryptionKeyId(), this.stampSheetConfiguration.namespaceName, this.stampSheetConfiguration.stampTaskEventHandler, this.stampSheetConfiguration.stampSheetEventHandler);
        try {
            stampSheet.run();
        }
        catch (Gs2Exception e) {
            throw new TransactionException(stampSheet, e);
        }
        return stampSheet;
    }

    public ProgressDomain deleteProgress(DeleteProgressByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        DeleteProgressByUserIdResult result = null;
        try {
            result = this.client.deleteProgressByUserId(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Progress");
        this.cache.delete(parentKey, ProgressDomain.createCacheKey(), Progress.class);
        ProgressDomain domain = new ProgressDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getUserId(), result.getItem().getTransactionId());
        return domain;
    }

    public DescribeProgressesByUserIdIterator progresses() {
        return new DescribeProgressesByUserIdIterator(this.cache, this.client, this.namespaceName, this.userId);
    }

    public ProgressDomain progress(String transactionId) {
        return new ProgressDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId, transactionId);
    }

    public DescribeCompletedQuestListsByUserIdIterator completedQuestLists() {
        return new DescribeCompletedQuestListsByUserIdIterator(this.cache, this.client, this.namespaceName, this.userId);
    }

    public CompletedQuestListDomain completedQuestList(String questGroupName) {
        return new CompletedQuestListDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId, questGroupName);
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "quest", namespaceName, userId, childType);
    }

    public static String createCacheKey(String userId) {
        return String.join((CharSequence)":", userId);
    }
}

