/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.quest.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.quest.Gs2QuestRestClient;
import io.gs2.quest.domain.model.QuestGroupModelMasterDomain;
import io.gs2.quest.model.QuestModelMaster;
import io.gs2.quest.request.DeleteQuestModelMasterRequest;
import io.gs2.quest.request.GetQuestModelMasterRequest;
import io.gs2.quest.request.UpdateQuestModelMasterRequest;
import io.gs2.quest.result.DeleteQuestModelMasterResult;
import io.gs2.quest.result.GetQuestModelMasterResult;
import io.gs2.quest.result.UpdateQuestModelMasterResult;

public class QuestModelMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2QuestRestClient client;
    private final String namespaceName;
    private final String questGroupName;
    private final String questName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getQuestGroupName() {
        return this.questGroupName;
    }

    public String getQuestName() {
        return this.questName;
    }

    public QuestModelMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String questGroupName, String questName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2QuestRestClient(session);
        this.namespaceName = namespaceName;
        this.questGroupName = questGroupName;
        this.questName = questName;
        this.parentKey = QuestGroupModelMasterDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.questGroupName != null ? this.questGroupName.toString() : null, "QuestModelMaster");
    }

    private QuestModelMaster get(GetQuestModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withQuestGroupName(this.questGroupName).withQuestName(this.questName);
        GetQuestModelMasterResult result = this.client.getQuestModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, QuestModelMasterDomain.createCacheKey(request.getQuestName() != null ? request.getQuestName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public QuestModelMasterDomain update(UpdateQuestModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withQuestGroupName(this.questGroupName).withQuestName(this.questName);
        UpdateQuestModelMasterResult result = this.client.updateQuestModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, QuestModelMasterDomain.createCacheKey(request.getQuestName() != null ? request.getQuestName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        QuestModelMasterDomain domain = this;
        return domain;
    }

    public QuestModelMasterDomain delete(DeleteQuestModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withQuestGroupName(this.questGroupName).withQuestName(this.questName);
        DeleteQuestModelMasterResult result = null;
        try {
            result = this.client.deleteQuestModelMaster(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, QuestModelMasterDomain.createCacheKey(request.getQuestName() != null ? request.getQuestName().toString() : null), QuestModelMaster.class);
        QuestModelMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String questGroupName, String questName, String childType) {
        return String.join((CharSequence)":", "quest", namespaceName, questGroupName, questName, childType);
    }

    public static String createCacheKey(String questName) {
        return String.join((CharSequence)":", questName);
    }

    public QuestModelMaster model() {
        QuestModelMaster value = this.cache.get(this.parentKey, QuestModelMasterDomain.createCacheKey(this.getQuestName() != null ? this.getQuestName().toString() : null), QuestModelMaster.class);
        if (value == null) {
            try {
                this.get(new GetQuestModelMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, QuestModelMasterDomain.createCacheKey(this.getQuestName() != null ? this.getQuestName().toString() : null), QuestModelMaster.class);
            }
            value = this.cache.get(this.parentKey, QuestModelMasterDomain.createCacheKey(this.getQuestName() != null ? this.getQuestName().toString() : null), QuestModelMaster.class);
        }
        return value;
    }
}

