/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.quest.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.quest.Gs2QuestRestClient;
import io.gs2.quest.domain.model.QuestGroupModelDomain;
import io.gs2.quest.model.QuestModel;
import io.gs2.quest.request.GetQuestModelRequest;
import io.gs2.quest.result.GetQuestModelResult;

public class QuestModelDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2QuestRestClient client;
    private final String namespaceName;
    private final String questGroupName;
    private final String questName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getQuestGroupName() {
        return this.questGroupName;
    }

    public String getQuestName() {
        return this.questName;
    }

    public QuestModelDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String questGroupName, String questName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2QuestRestClient(session);
        this.namespaceName = namespaceName;
        this.questGroupName = questGroupName;
        this.questName = questName;
        this.parentKey = QuestGroupModelDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.questGroupName != null ? this.questGroupName.toString() : null, "QuestModel");
    }

    private QuestModel get(GetQuestModelRequest request) {
        request.withNamespaceName(this.namespaceName).withQuestGroupName(this.questGroupName).withQuestName(this.questName);
        GetQuestModelResult result = this.client.getQuestModel(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, QuestModelDomain.createCacheKey(request.getQuestName() != null ? request.getQuestName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public static String createCacheParentKey(String namespaceName, String questGroupName, String questName, String childType) {
        return String.join((CharSequence)":", "quest", namespaceName, questGroupName, questName, childType);
    }

    public static String createCacheKey(String questName) {
        return String.join((CharSequence)":", questName);
    }

    public QuestModel model() {
        QuestModel value = this.cache.get(this.parentKey, QuestModelDomain.createCacheKey(this.getQuestName() != null ? this.getQuestName().toString() : null), QuestModel.class);
        if (value == null) {
            try {
                this.get(new GetQuestModelRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, QuestModelDomain.createCacheKey(this.getQuestName() != null ? this.getQuestName().toString() : null), QuestModel.class);
            }
            value = this.cache.get(this.parentKey, QuestModelDomain.createCacheKey(this.getQuestName() != null ? this.getQuestName().toString() : null), QuestModel.class);
        }
        return value;
    }
}

