/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.quest.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.quest.Gs2QuestRestClient;
import io.gs2.quest.domain.iterator.DescribeQuestModelMastersIterator;
import io.gs2.quest.domain.model.NamespaceDomain;
import io.gs2.quest.domain.model.QuestModelMasterDomain;
import io.gs2.quest.model.QuestGroupModelMaster;
import io.gs2.quest.request.CreateQuestModelMasterRequest;
import io.gs2.quest.request.DeleteQuestGroupModelMasterRequest;
import io.gs2.quest.request.GetQuestGroupModelMasterRequest;
import io.gs2.quest.request.UpdateQuestGroupModelMasterRequest;
import io.gs2.quest.result.CreateQuestModelMasterResult;
import io.gs2.quest.result.DeleteQuestGroupModelMasterResult;
import io.gs2.quest.result.GetQuestGroupModelMasterResult;
import io.gs2.quest.result.UpdateQuestGroupModelMasterResult;

public class QuestGroupModelMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2QuestRestClient client;
    private final String namespaceName;
    private final String questGroupName;
    private final String parentKey;
    String nextPageToken;

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getQuestGroupName() {
        return this.questGroupName;
    }

    public QuestGroupModelMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String questGroupName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2QuestRestClient(session);
        this.namespaceName = namespaceName;
        this.questGroupName = questGroupName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "QuestGroupModelMaster");
    }

    private QuestGroupModelMaster get(GetQuestGroupModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withQuestGroupName(this.questGroupName);
        GetQuestGroupModelMasterResult result = this.client.getQuestGroupModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, QuestGroupModelMasterDomain.createCacheKey(request.getQuestGroupName() != null ? request.getQuestGroupName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public QuestGroupModelMasterDomain update(UpdateQuestGroupModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withQuestGroupName(this.questGroupName);
        UpdateQuestGroupModelMasterResult result = this.client.updateQuestGroupModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, QuestGroupModelMasterDomain.createCacheKey(request.getQuestGroupName() != null ? request.getQuestGroupName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        QuestGroupModelMasterDomain domain = this;
        return domain;
    }

    public QuestGroupModelMasterDomain delete(DeleteQuestGroupModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withQuestGroupName(this.questGroupName);
        DeleteQuestGroupModelMasterResult result = null;
        try {
            result = this.client.deleteQuestGroupModelMaster(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, QuestGroupModelMasterDomain.createCacheKey(request.getQuestGroupName() != null ? request.getQuestGroupName().toString() : null), QuestGroupModelMaster.class);
        QuestGroupModelMasterDomain domain = this;
        return domain;
    }

    public QuestModelMasterDomain createQuestModelMaster(CreateQuestModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withQuestGroupName(this.questGroupName);
        CreateQuestModelMasterResult result = this.client.createQuestModelMaster(request);
        String parentKey = QuestGroupModelMasterDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.questGroupName != null ? this.questGroupName.toString() : null, "QuestModelMaster");
        if (result.getItem() != null) {
            this.cache.put(parentKey, QuestModelMasterDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        QuestModelMasterDomain domain = new QuestModelMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getQuestGroupName(), result.getItem().getName());
        return domain;
    }

    public DescribeQuestModelMastersIterator questModelMasters() {
        return new DescribeQuestModelMastersIterator(this.cache, this.client, this.namespaceName, this.questGroupName);
    }

    public QuestModelMasterDomain questModelMaster(String questName) {
        return new QuestModelMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.questGroupName, questName);
    }

    public static String createCacheParentKey(String namespaceName, String questGroupName, String childType) {
        return String.join((CharSequence)":", "quest", namespaceName, questGroupName, childType);
    }

    public static String createCacheKey(String questGroupName) {
        return String.join((CharSequence)":", questGroupName);
    }

    public QuestGroupModelMaster model() {
        QuestGroupModelMaster value = this.cache.get(this.parentKey, QuestGroupModelMasterDomain.createCacheKey(this.getQuestGroupName() != null ? this.getQuestGroupName().toString() : null), QuestGroupModelMaster.class);
        if (value == null) {
            try {
                this.get(new GetQuestGroupModelMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, QuestGroupModelMasterDomain.createCacheKey(this.getQuestGroupName() != null ? this.getQuestGroupName().toString() : null), QuestGroupModelMaster.class);
            }
            value = this.cache.get(this.parentKey, QuestGroupModelMasterDomain.createCacheKey(this.getQuestGroupName() != null ? this.getQuestGroupName().toString() : null), QuestGroupModelMaster.class);
        }
        return value;
    }
}

