/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.quest.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.quest.Gs2QuestRestClient;
import io.gs2.quest.domain.iterator.DescribeQuestModelsIterator;
import io.gs2.quest.domain.model.NamespaceDomain;
import io.gs2.quest.domain.model.QuestModelDomain;
import io.gs2.quest.model.QuestGroupModel;
import io.gs2.quest.request.GetQuestGroupModelRequest;
import io.gs2.quest.result.GetQuestGroupModelResult;

public class QuestGroupModelDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2QuestRestClient client;
    private final String namespaceName;
    private final String questGroupName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getQuestGroupName() {
        return this.questGroupName;
    }

    public QuestGroupModelDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String questGroupName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2QuestRestClient(session);
        this.namespaceName = namespaceName;
        this.questGroupName = questGroupName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "QuestGroupModel");
    }

    private QuestGroupModel get(GetQuestGroupModelRequest request) {
        request.withNamespaceName(this.namespaceName).withQuestGroupName(this.questGroupName);
        GetQuestGroupModelResult result = this.client.getQuestGroupModel(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, QuestGroupModelDomain.createCacheKey(request.getQuestGroupName() != null ? request.getQuestGroupName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public DescribeQuestModelsIterator questModels() {
        return new DescribeQuestModelsIterator(this.cache, this.client, this.namespaceName, this.questGroupName);
    }

    public QuestModelDomain questModel(String questName) {
        return new QuestModelDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.questGroupName, questName);
    }

    public static String createCacheParentKey(String namespaceName, String questGroupName, String childType) {
        return String.join((CharSequence)":", "quest", namespaceName, questGroupName, childType);
    }

    public static String createCacheKey(String questGroupName) {
        return String.join((CharSequence)":", questGroupName);
    }

    public QuestGroupModel model() {
        QuestGroupModel value = this.cache.get(this.parentKey, QuestGroupModelDomain.createCacheKey(this.getQuestGroupName() != null ? this.getQuestGroupName().toString() : null), QuestGroupModel.class);
        if (value == null) {
            try {
                this.get(new GetQuestGroupModelRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, QuestGroupModelDomain.createCacheKey(this.getQuestGroupName() != null ? this.getQuestGroupName().toString() : null), QuestGroupModel.class);
            }
            value = this.cache.get(this.parentKey, QuestGroupModelDomain.createCacheKey(this.getQuestGroupName() != null ? this.getQuestGroupName().toString() : null), QuestGroupModel.class);
        }
        return value;
    }
}

