/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.quest.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.quest.Gs2QuestRestClient;
import io.gs2.quest.domain.model.UserDomain;
import io.gs2.quest.model.CompletedQuestList;
import io.gs2.quest.request.DeleteCompletedQuestListByUserIdRequest;
import io.gs2.quest.request.GetCompletedQuestListByUserIdRequest;
import io.gs2.quest.result.DeleteCompletedQuestListByUserIdResult;
import io.gs2.quest.result.GetCompletedQuestListByUserIdResult;

public class CompletedQuestListDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2QuestRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String questGroupName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getQuestGroupName() {
        return this.questGroupName;
    }

    public CompletedQuestListDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, String questGroupName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2QuestRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.questGroupName = questGroupName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "CompletedQuestList");
    }

    private CompletedQuestList get(GetCompletedQuestListByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withQuestGroupName(this.questGroupName);
        GetCompletedQuestListByUserIdResult result = this.client.getCompletedQuestListByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CompletedQuestListDomain.createCacheKey(request.getQuestGroupName() != null ? request.getQuestGroupName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public CompletedQuestListDomain delete(DeleteCompletedQuestListByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withQuestGroupName(this.questGroupName);
        DeleteCompletedQuestListByUserIdResult result = null;
        try {
            result = this.client.deleteCompletedQuestListByUserId(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, CompletedQuestListDomain.createCacheKey(request.getQuestGroupName() != null ? request.getQuestGroupName().toString() : null), CompletedQuestList.class);
        CompletedQuestListDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String questGroupName, String childType) {
        return String.join((CharSequence)":", "quest", namespaceName, userId, questGroupName, childType);
    }

    public static String createCacheKey(String questGroupName) {
        return String.join((CharSequence)":", questGroupName);
    }

    public CompletedQuestList model() {
        CompletedQuestList value = this.cache.get(this.parentKey, CompletedQuestListDomain.createCacheKey(this.getQuestGroupName() != null ? this.getQuestGroupName().toString() : null), CompletedQuestList.class);
        if (value == null) {
            try {
                this.get(new GetCompletedQuestListByUserIdRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, CompletedQuestListDomain.createCacheKey(this.getQuestGroupName() != null ? this.getQuestGroupName().toString() : null), CompletedQuestList.class);
            }
            value = this.cache.get(this.parentKey, CompletedQuestListDomain.createCacheKey(this.getQuestGroupName() != null ? this.getQuestGroupName().toString() : null), CompletedQuestList.class);
        }
        return value;
    }
}

