/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.quest.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.quest.Gs2QuestRestClient;
import io.gs2.quest.domain.model.QuestGroupModelMasterDomain;
import io.gs2.quest.domain.model.QuestModelMasterDomain;
import io.gs2.quest.model.QuestModelMaster;
import io.gs2.quest.request.DescribeQuestModelMastersRequest;
import io.gs2.quest.result.DescribeQuestModelMastersResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeQuestModelMastersIterator
implements Iterator<QuestModelMaster>,
Iterable<QuestModelMaster> {
    CacheDatabase cache;
    Gs2QuestRestClient client;
    String namespaceName;
    String questGroupName;
    String pageToken;
    boolean last;
    List<QuestModelMaster> result;
    Integer fetchSize;

    public DescribeQuestModelMastersIterator(CacheDatabase cache, Gs2QuestRestClient client, String namespaceName, String questGroupName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.questGroupName = questGroupName;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<QuestModelMaster>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = QuestGroupModelMasterDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.questGroupName != null ? this.questGroupName.toString() : null, "QuestModelMaster");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, QuestModelMaster.class)) {
            this.result = this.cache.list(parentKey, QuestModelMaster.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeQuestModelMastersResult r = this.client.describeQuestModelMasters(new DescribeQuestModelMastersRequest().withNamespaceName(this.namespaceName).withQuestGroupName(this.questGroupName).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (QuestModelMaster item : this.result) {
                this.cache.put(parentKey, QuestModelMasterDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, QuestModelMaster.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public QuestModelMaster next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        QuestModelMaster ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<QuestModelMaster> iterator() {
        return this;
    }
}

