/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.quest.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.quest.Gs2QuestRestClient;
import io.gs2.quest.domain.model.CompletedQuestListDomain;
import io.gs2.quest.domain.model.UserDomain;
import io.gs2.quest.model.CompletedQuestList;
import io.gs2.quest.request.DescribeCompletedQuestListsByUserIdRequest;
import io.gs2.quest.result.DescribeCompletedQuestListsByUserIdResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeCompletedQuestListsByUserIdIterator
implements Iterator<CompletedQuestList>,
Iterable<CompletedQuestList> {
    CacheDatabase cache;
    Gs2QuestRestClient client;
    String namespaceName;
    String userId;
    String pageToken;
    boolean last;
    List<CompletedQuestList> result;
    Integer fetchSize;

    public DescribeCompletedQuestListsByUserIdIterator(CacheDatabase cache, Gs2QuestRestClient client, String namespaceName, String userId) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<CompletedQuestList>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "CompletedQuestList");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, CompletedQuestList.class)) {
            this.result = this.cache.list(parentKey, CompletedQuestList.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeCompletedQuestListsByUserIdResult r = this.client.describeCompletedQuestListsByUserId(new DescribeCompletedQuestListsByUserIdRequest().withNamespaceName(this.namespaceName).withUserId(this.userId).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (CompletedQuestList item : this.result) {
                this.cache.put(parentKey, CompletedQuestListDomain.createCacheKey(item.getQuestGroupName() != null ? item.getQuestGroupName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, CompletedQuestList.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public CompletedQuestList next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        CompletedQuestList ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<CompletedQuestList> iterator() {
        return this;
    }
}

