/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.news.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.news.Gs2NewsRestClient;
import io.gs2.news.domain.iterator.DescribeNewsByUserIdIterator;
import io.gs2.news.domain.model.NamespaceDomain;
import io.gs2.news.domain.model.NewsDomain;
import io.gs2.news.domain.model.SetCookieRequestEntryDomain;

public class UserDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2NewsRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String parentKey;
    String contentHash;
    String templateHash;

    public String getContentHash() {
        return this.contentHash;
    }

    public String getTemplateHash() {
        return this.templateHash;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public UserDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2NewsRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "User");
    }

    public DescribeNewsByUserIdIterator newses() {
        return new DescribeNewsByUserIdIterator(this.cache, this.client, this.namespaceName, this.userId);
    }

    public NewsDomain news() {
        return new NewsDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId);
    }

    public SetCookieRequestEntryDomain setCookieRequestEntry(String key, String value) {
        return new SetCookieRequestEntryDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId, key, value);
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "news", namespaceName, userId, childType);
    }

    public static String createCacheKey(String userId) {
        return String.join((CharSequence)":", userId);
    }
}

