/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.money.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.money.Gs2MoneyRestClient;
import io.gs2.money.domain.model.UserDomain;
import io.gs2.money.domain.model.WalletDomain;
import io.gs2.money.model.Wallet;
import io.gs2.money.request.GetWalletRequest;
import io.gs2.money.request.WithdrawRequest;
import io.gs2.money.result.GetWalletResult;
import io.gs2.money.result.WithdrawResult;

public class WalletAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2MoneyRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final Integer slot;
    private final String parentKey;
    Float price;

    public Float getPrice() {
        return this.price;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public Integer getSlot() {
        return this.slot;
    }

    public WalletAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken, Integer slot) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2MoneyRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.slot = slot;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Wallet");
    }

    private Wallet get(GetWalletRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withSlot(this.slot);
        GetWalletResult result = this.client.getWallet(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, WalletDomain.createCacheKey(request.getSlot() != null ? request.getSlot().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public WalletAccessTokenDomain withdraw(WithdrawRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withSlot(this.slot);
        WithdrawResult result = this.client.withdraw(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, WalletDomain.createCacheKey(request.getSlot() != null ? request.getSlot().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        WalletAccessTokenDomain domain = this;
        domain.price = result.getPrice();
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String slot, String childType) {
        return String.join((CharSequence)":", "money", namespaceName, userId, slot, childType);
    }

    public static String createCacheKey(String slot) {
        return String.join((CharSequence)":", slot);
    }

    public Wallet model() {
        Wallet value = this.cache.get(this.parentKey, WalletDomain.createCacheKey(this.getSlot() != null ? this.getSlot().toString() : null), Wallet.class);
        if (value == null) {
            try {
                this.get(new GetWalletRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, WalletDomain.createCacheKey(this.getSlot() != null ? this.getSlot().toString() : null), Wallet.class);
            }
            value = this.cache.get(this.parentKey, WalletDomain.createCacheKey(this.getSlot() != null ? this.getSlot().toString() : null), Wallet.class);
        }
        return value;
    }
}

