/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.money.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.money.Gs2MoneyRestClient;
import io.gs2.money.domain.iterator.DescribeReceiptsIterator;
import io.gs2.money.domain.iterator.DescribeWalletsByUserIdIterator;
import io.gs2.money.domain.model.NamespaceDomain;
import io.gs2.money.domain.model.ReceiptDomain;
import io.gs2.money.domain.model.WalletDomain;
import io.gs2.money.request.RecordReceiptRequest;
import io.gs2.money.result.RecordReceiptResult;

public class UserDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2MoneyRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String parentKey;
    Float price;
    String nextPageToken;

    public Float getPrice() {
        return this.price;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public UserDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2MoneyRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "User");
    }

    public ReceiptDomain recordReceipt(RecordReceiptRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        RecordReceiptResult result = this.client.recordReceipt(request);
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Receipt");
        if (result.getItem() != null) {
            this.cache.put(parentKey, ReceiptDomain.createCacheKey(result.getItem().getTransactionId() != null ? result.getItem().getTransactionId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        ReceiptDomain domain = new ReceiptDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getUserId(), result.getItem().getTransactionId());
        return domain;
    }

    public DescribeWalletsByUserIdIterator wallets() {
        return new DescribeWalletsByUserIdIterator(this.cache, this.client, this.namespaceName, this.userId);
    }

    public WalletDomain wallet(Integer slot) {
        return new WalletDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId, slot);
    }

    public DescribeReceiptsIterator receipts(Integer slot, Long begin, Long end) {
        return new DescribeReceiptsIterator(this.cache, this.client, this.namespaceName, this.userId, slot, begin, end);
    }

    public ReceiptDomain receipt(String transactionId) {
        return new ReceiptDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId, transactionId);
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "money", namespaceName, userId, childType);
    }

    public static String createCacheKey(String userId) {
        return String.join((CharSequence)":", userId);
    }
}

