/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.money.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.money.Gs2MoneyRestClient;
import io.gs2.money.domain.model.ReceiptDomain;
import io.gs2.money.domain.model.UserDomain;
import io.gs2.money.model.Receipt;

public class ReceiptAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2MoneyRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String transactionId;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public ReceiptAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken, String transactionId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2MoneyRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.transactionId = transactionId;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Receipt");
    }

    public static String createCacheParentKey(String namespaceName, String userId, String transactionId, String childType) {
        return String.join((CharSequence)":", "money", namespaceName, userId, transactionId, childType);
    }

    public static String createCacheKey(String transactionId) {
        return String.join((CharSequence)":", transactionId);
    }

    public Receipt model() {
        Receipt value = this.cache.get(this.parentKey, ReceiptDomain.createCacheKey(this.getTransactionId() != null ? this.getTransactionId().toString() : null), Receipt.class);
        return value;
    }
}

