/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.money.domain.iterator;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.money.Gs2MoneyRestClient;
import io.gs2.money.domain.model.UserDomain;
import io.gs2.money.domain.model.WalletDomain;
import io.gs2.money.model.Wallet;
import io.gs2.money.request.DescribeWalletsRequest;
import io.gs2.money.result.DescribeWalletsResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeWalletsIterator
implements Iterator<Wallet>,
Iterable<Wallet> {
    CacheDatabase cache;
    Gs2MoneyRestClient client;
    String namespaceName;
    AccessToken accessToken;
    String pageToken;
    boolean last;
    List<Wallet> result;
    Integer fetchSize;

    public DescribeWalletsIterator(CacheDatabase cache, Gs2MoneyRestClient client, String namespaceName, AccessToken accessToken) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<Wallet>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Wallet");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, Wallet.class)) {
            this.result = this.cache.list(parentKey, Wallet.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeWalletsResult r = this.client.describeWallets(new DescribeWalletsRequest().withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (Wallet item : this.result) {
                this.cache.put(parentKey, WalletDomain.createCacheKey(item.getSlot() != null ? item.getSlot().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, Wallet.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public Wallet next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        Wallet ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<Wallet> iterator() {
        return this;
    }
}

