/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.money.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.money.Gs2MoneyRestClient;
import io.gs2.money.domain.model.ReceiptDomain;
import io.gs2.money.domain.model.UserDomain;
import io.gs2.money.model.Receipt;
import io.gs2.money.request.DescribeReceiptsRequest;
import io.gs2.money.result.DescribeReceiptsResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeReceiptsIterator
implements Iterator<Receipt>,
Iterable<Receipt> {
    CacheDatabase cache;
    Gs2MoneyRestClient client;
    String namespaceName;
    String userId;
    Integer slot;
    Long begin;
    Long end;
    String pageToken;
    boolean last;
    List<Receipt> result;
    Integer fetchSize;

    public DescribeReceiptsIterator(CacheDatabase cache, Gs2MoneyRestClient client, String namespaceName, String userId, Integer slot, Long begin, Long end) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.slot = slot;
        this.begin = begin;
        this.end = end;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<Receipt>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Receipt");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, Receipt.class)) {
            this.result = this.cache.list(parentKey, Receipt.class).stream().filter(item -> this.slot == null || item.getSlot().equals(this.slot)).filter(item -> this.begin == null || item.getCreatedAt() >= this.begin).filter(item -> this.end == null || item.getCreatedAt() <= this.end).collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeReceiptsResult r = this.client.describeReceipts(new DescribeReceiptsRequest().withNamespaceName(this.namespaceName).withUserId(this.userId).withSlot(this.slot).withBegin(this.begin).withEnd(this.end).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (Receipt item2 : this.result) {
                this.cache.put(parentKey, ReceiptDomain.createCacheKey(item2.getTransactionId() != null ? item2.getTransactionId().toString() : null), item2, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, Receipt.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public Receipt next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        Receipt ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<Receipt> iterator() {
        return this;
    }
}

