/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.mission.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.mission.Gs2MissionRestClient;
import io.gs2.mission.domain.model.MissionGroupModelDomain;
import io.gs2.mission.model.MissionTaskModel;
import io.gs2.mission.request.GetMissionTaskModelRequest;
import io.gs2.mission.result.GetMissionTaskModelResult;

public class MissionTaskModelDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2MissionRestClient client;
    private final String namespaceName;
    private final String missionGroupName;
    private final String missionTaskName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getMissionGroupName() {
        return this.missionGroupName;
    }

    public String getMissionTaskName() {
        return this.missionTaskName;
    }

    public MissionTaskModelDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String missionGroupName, String missionTaskName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2MissionRestClient(session);
        this.namespaceName = namespaceName;
        this.missionGroupName = missionGroupName;
        this.missionTaskName = missionTaskName;
        this.parentKey = MissionGroupModelDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.missionGroupName != null ? this.missionGroupName.toString() : null, "MissionTaskModel");
    }

    private MissionTaskModel get(GetMissionTaskModelRequest request) {
        request.withNamespaceName(this.namespaceName).withMissionGroupName(this.missionGroupName).withMissionTaskName(this.missionTaskName);
        GetMissionTaskModelResult result = this.client.getMissionTaskModel(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, MissionTaskModelDomain.createCacheKey(request.getMissionTaskName() != null ? request.getMissionTaskName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public static String createCacheParentKey(String namespaceName, String missionGroupName, String missionTaskName, String childType) {
        return String.join((CharSequence)":", "mission", namespaceName, missionGroupName, missionTaskName, childType);
    }

    public static String createCacheKey(String missionTaskName) {
        return String.join((CharSequence)":", missionTaskName);
    }

    public MissionTaskModel model() {
        MissionTaskModel value = this.cache.get(this.parentKey, MissionTaskModelDomain.createCacheKey(this.getMissionTaskName() != null ? this.getMissionTaskName().toString() : null), MissionTaskModel.class);
        if (value == null) {
            try {
                this.get(new GetMissionTaskModelRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, MissionTaskModelDomain.createCacheKey(this.getMissionTaskName() != null ? this.getMissionTaskName().toString() : null), MissionTaskModel.class);
            }
            value = this.cache.get(this.parentKey, MissionTaskModelDomain.createCacheKey(this.getMissionTaskName() != null ? this.getMissionTaskName().toString() : null), MissionTaskModel.class);
        }
        return value;
    }
}

