/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.mission.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.mission.Gs2MissionRestClient;
import io.gs2.mission.domain.iterator.DescribeMissionTaskModelMastersIterator;
import io.gs2.mission.domain.model.MissionTaskModelMasterDomain;
import io.gs2.mission.domain.model.NamespaceDomain;
import io.gs2.mission.model.MissionGroupModelMaster;
import io.gs2.mission.request.CreateMissionTaskModelMasterRequest;
import io.gs2.mission.request.DeleteMissionGroupModelMasterRequest;
import io.gs2.mission.request.GetMissionGroupModelMasterRequest;
import io.gs2.mission.request.UpdateMissionGroupModelMasterRequest;
import io.gs2.mission.result.CreateMissionTaskModelMasterResult;
import io.gs2.mission.result.DeleteMissionGroupModelMasterResult;
import io.gs2.mission.result.GetMissionGroupModelMasterResult;
import io.gs2.mission.result.UpdateMissionGroupModelMasterResult;

public class MissionGroupModelMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2MissionRestClient client;
    private final String namespaceName;
    private final String missionGroupName;
    private final String parentKey;
    String nextPageToken;

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getMissionGroupName() {
        return this.missionGroupName;
    }

    public MissionGroupModelMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String missionGroupName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2MissionRestClient(session);
        this.namespaceName = namespaceName;
        this.missionGroupName = missionGroupName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "MissionGroupModelMaster");
    }

    private MissionGroupModelMaster get(GetMissionGroupModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withMissionGroupName(this.missionGroupName);
        GetMissionGroupModelMasterResult result = this.client.getMissionGroupModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, MissionGroupModelMasterDomain.createCacheKey(request.getMissionGroupName() != null ? request.getMissionGroupName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public MissionGroupModelMasterDomain update(UpdateMissionGroupModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withMissionGroupName(this.missionGroupName);
        UpdateMissionGroupModelMasterResult result = this.client.updateMissionGroupModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, MissionGroupModelMasterDomain.createCacheKey(request.getMissionGroupName() != null ? request.getMissionGroupName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        MissionGroupModelMasterDomain domain = this;
        return domain;
    }

    public MissionGroupModelMasterDomain delete(DeleteMissionGroupModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withMissionGroupName(this.missionGroupName);
        DeleteMissionGroupModelMasterResult result = null;
        try {
            result = this.client.deleteMissionGroupModelMaster(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, MissionGroupModelMasterDomain.createCacheKey(request.getMissionGroupName() != null ? request.getMissionGroupName().toString() : null), MissionGroupModelMaster.class);
        MissionGroupModelMasterDomain domain = this;
        return domain;
    }

    public MissionTaskModelMasterDomain createMissionTaskModelMaster(CreateMissionTaskModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withMissionGroupName(this.missionGroupName);
        CreateMissionTaskModelMasterResult result = this.client.createMissionTaskModelMaster(request);
        String parentKey = MissionGroupModelMasterDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.missionGroupName != null ? this.missionGroupName.toString() : null, "MissionTaskModelMaster");
        if (result.getItem() != null) {
            this.cache.put(parentKey, MissionTaskModelMasterDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        MissionTaskModelMasterDomain domain = new MissionTaskModelMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), request.getMissionGroupName(), result.getItem().getName());
        return domain;
    }

    public DescribeMissionTaskModelMastersIterator missionTaskModelMasters() {
        return new DescribeMissionTaskModelMastersIterator(this.cache, this.client, this.namespaceName, this.missionGroupName);
    }

    public MissionTaskModelMasterDomain missionTaskModelMaster(String missionTaskName) {
        return new MissionTaskModelMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.missionGroupName, missionTaskName);
    }

    public static String createCacheParentKey(String namespaceName, String missionGroupName, String childType) {
        return String.join((CharSequence)":", "mission", namespaceName, missionGroupName, childType);
    }

    public static String createCacheKey(String missionGroupName) {
        return String.join((CharSequence)":", missionGroupName);
    }

    public MissionGroupModelMaster model() {
        MissionGroupModelMaster value = this.cache.get(this.parentKey, MissionGroupModelMasterDomain.createCacheKey(this.getMissionGroupName() != null ? this.getMissionGroupName().toString() : null), MissionGroupModelMaster.class);
        if (value == null) {
            try {
                this.get(new GetMissionGroupModelMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, MissionGroupModelMasterDomain.createCacheKey(this.getMissionGroupName() != null ? this.getMissionGroupName().toString() : null), MissionGroupModelMaster.class);
            }
            value = this.cache.get(this.parentKey, MissionGroupModelMasterDomain.createCacheKey(this.getMissionGroupName() != null ? this.getMissionGroupName().toString() : null), MissionGroupModelMaster.class);
        }
        return value;
    }
}

