/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.mission.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.mission.Gs2MissionRestClient;
import io.gs2.mission.domain.model.CounterDomain;
import io.gs2.mission.domain.model.UserDomain;
import io.gs2.mission.model.Counter;
import io.gs2.mission.model.ScopedValue;
import io.gs2.mission.request.GetCounterRequest;
import io.gs2.mission.result.GetCounterResult;

public class CounterAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2MissionRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String counterName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public String getCounterName() {
        return this.counterName;
    }

    public CounterAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken, String counterName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2MissionRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.counterName = counterName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Counter");
    }

    private Counter get(GetCounterRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withCounterName(this.counterName);
        GetCounterResult result = this.client.getCounter(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CounterDomain.createCacheKey(request.getCounterName() != null ? request.getCounterName().toString() : null), result.getItem(), result.getItem().getValues().stream().map(ScopedValue::getNextResetAt).map(i -> i == null ? System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes : i).min((i, j) -> (int)(i - j)).orElse(System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes));
        }
        return result.getItem();
    }

    public static String createCacheParentKey(String namespaceName, String userId, String counterName, String childType) {
        return String.join((CharSequence)":", "mission", namespaceName, userId, counterName, childType);
    }

    public static String createCacheKey(String counterName) {
        return String.join((CharSequence)":", counterName);
    }

    public Counter model() {
        Counter value = this.cache.get(this.parentKey, CounterDomain.createCacheKey(this.getCounterName() != null ? this.getCounterName().toString() : null), Counter.class);
        if (value == null) {
            try {
                this.get(new GetCounterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, CounterDomain.createCacheKey(this.getCounterName() != null ? this.getCounterName().toString() : null), Counter.class);
            }
            value = this.cache.get(this.parentKey, CounterDomain.createCacheKey(this.getCounterName() != null ? this.getCounterName().toString() : null), Counter.class);
        }
        return value;
    }
}

