/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.mission.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.domain.StampSheetDomain;
import io.gs2.core.exception.Gs2Exception;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.exception.TransactionException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.mission.Gs2MissionRestClient;
import io.gs2.mission.domain.model.UserDomain;
import io.gs2.mission.model.Complete;
import io.gs2.mission.request.CompleteByUserIdRequest;
import io.gs2.mission.request.DeleteCompleteByUserIdRequest;
import io.gs2.mission.request.GetCompleteByUserIdRequest;
import io.gs2.mission.request.ReceiveByUserIdRequest;
import io.gs2.mission.result.CompleteByUserIdResult;
import io.gs2.mission.result.DeleteCompleteByUserIdResult;
import io.gs2.mission.result.GetCompleteByUserIdResult;
import io.gs2.mission.result.ReceiveByUserIdResult;

public class CompleteDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2MissionRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String missionGroupName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getMissionGroupName() {
        return this.missionGroupName;
    }

    public CompleteDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, String missionGroupName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2MissionRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.missionGroupName = missionGroupName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Complete");
    }

    public StampSheetDomain complete(CompleteByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withMissionGroupName(this.missionGroupName);
        CompleteByUserIdResult result = this.client.completeByUserId(request);
        StampSheetDomain stampSheet = new StampSheetDomain(this.cache, this.jobQueueDomain, this.session, result.getStampSheet(), result.getStampSheetEncryptionKeyId(), this.stampSheetConfiguration.namespaceName, this.stampSheetConfiguration.stampTaskEventHandler, this.stampSheetConfiguration.stampSheetEventHandler);
        try {
            stampSheet.run();
        }
        catch (Gs2Exception e) {
            throw new TransactionException(stampSheet, e);
        }
        return stampSheet;
    }

    public CompleteDomain receive(ReceiveByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withMissionGroupName(this.missionGroupName);
        ReceiveByUserIdResult result = this.client.receiveByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CompleteDomain.createCacheKey(request.getMissionGroupName() != null ? request.getMissionGroupName().toString() : null), result.getItem(), result.getItem().getNextResetAt() == null ? System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes : result.getItem().getNextResetAt());
        }
        CompleteDomain domain = this;
        return domain;
    }

    private Complete get(GetCompleteByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withMissionGroupName(this.missionGroupName);
        GetCompleteByUserIdResult result = this.client.getCompleteByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CompleteDomain.createCacheKey(request.getMissionGroupName() != null ? request.getMissionGroupName().toString() : null), result.getItem(), result.getItem().getNextResetAt() == null ? System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes : result.getItem().getNextResetAt());
        }
        return result.getItem();
    }

    public CompleteDomain delete(DeleteCompleteByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withMissionGroupName(this.missionGroupName);
        DeleteCompleteByUserIdResult result = null;
        try {
            result = this.client.deleteCompleteByUserId(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, CompleteDomain.createCacheKey(request.getMissionGroupName() != null ? request.getMissionGroupName().toString() : null), Complete.class);
        CompleteDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String missionGroupName, String childType) {
        return String.join((CharSequence)":", "mission", namespaceName, userId, missionGroupName, childType);
    }

    public static String createCacheKey(String missionGroupName) {
        return String.join((CharSequence)":", missionGroupName);
    }

    public Complete model() {
        Complete value = this.cache.get(this.parentKey, CompleteDomain.createCacheKey(this.getMissionGroupName() != null ? this.getMissionGroupName().toString() : null), Complete.class);
        if (value == null) {
            try {
                this.get(new GetCompleteByUserIdRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, CompleteDomain.createCacheKey(this.getMissionGroupName() != null ? this.getMissionGroupName().toString() : null), Complete.class);
            }
            value = this.cache.get(this.parentKey, CompleteDomain.createCacheKey(this.getMissionGroupName() != null ? this.getMissionGroupName().toString() : null), Complete.class);
        }
        return value;
    }
}

