/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.mission.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.mission.Gs2MissionRestClient;
import io.gs2.mission.domain.model.CounterModelDomain;
import io.gs2.mission.domain.model.NamespaceDomain;
import io.gs2.mission.model.CounterModel;
import io.gs2.mission.request.DescribeCounterModelsRequest;
import io.gs2.mission.result.DescribeCounterModelsResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeCounterModelsIterator
implements Iterator<CounterModel>,
Iterable<CounterModel> {
    CacheDatabase cache;
    Gs2MissionRestClient client;
    String namespaceName;
    boolean last;
    List<CounterModel> result;
    Integer fetchSize;

    public DescribeCounterModelsIterator(CacheDatabase cache, Gs2MissionRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.last = false;
        this.result = new ArrayList<CounterModel>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "CounterModel");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, CounterModel.class)) {
            this.result = this.cache.list(parentKey, CounterModel.class).stream().collect(Collectors.toList());
            this.last = true;
        } else {
            DescribeCounterModelsResult r = this.client.describeCounterModels(new DescribeCounterModelsRequest().withNamespaceName(this.namespaceName));
            this.result = r.getItems();
            this.last = true;
            for (CounterModel item : this.result) {
                this.cache.put(parentKey, CounterModelDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, CounterModel.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public CounterModel next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        CounterModel ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<CounterModel> iterator() {
        return this;
    }
}

