/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.mission.domain;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.jobQueue.model.Job;
import io.gs2.jobQueue.model.JobResultBody;
import io.gs2.mission.Gs2MissionRestClient;
import io.gs2.mission.domain.iterator.DescribeNamespacesIterator;
import io.gs2.mission.domain.model.CompleteDomain;
import io.gs2.mission.domain.model.CounterDomain;
import io.gs2.mission.domain.model.NamespaceDomain;
import io.gs2.mission.domain.model.UserDomain;
import io.gs2.mission.model.Complete;
import io.gs2.mission.request.CreateNamespaceRequest;
import io.gs2.mission.request.IncreaseCounterByUserIdRequest;
import io.gs2.mission.request.ReceiveByUserIdRequest;
import io.gs2.mission.result.CreateNamespaceResult;
import io.gs2.mission.result.IncreaseCounterByUserIdResult;
import io.gs2.mission.result.ReceiveByUserIdResult;

public class Gs2Mission {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2MissionRestClient client;
    private final String parentKey;

    public Gs2Mission(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2MissionRestClient(session);
        this.parentKey = "mission";
    }

    public NamespaceDomain createNamespace(CreateNamespaceRequest request) {
        CreateNamespaceResult result = this.client.createNamespace(request);
        String parentKey = "mission:Namespace";
        if (result.getItem() != null) {
            this.cache.put(parentKey, NamespaceDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        NamespaceDomain domain = new NamespaceDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, result.getItem().getName());
        return domain;
    }

    public DescribeNamespacesIterator namespaces() {
        return new DescribeNamespacesIterator(this.cache, this.client);
    }

    public NamespaceDomain namespace(String namespaceName) {
        return new NamespaceDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, namespaceName);
    }

    public static void updateCacheFromStampSheet(CacheDatabase cache, String method, String request, String result) {
        try {
            switch (method) {
                case "IncreaseCounterByUserId": {
                    IncreaseCounterByUserIdRequest requestModel = IncreaseCounterByUserIdRequest.fromJson(new ObjectMapper().readTree(request));
                    IncreaseCounterByUserIdResult resultModel = IncreaseCounterByUserIdResult.fromJson(new ObjectMapper().readTree(result));
                    String parentKey = UserDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), resultModel.getItem().getUserId().toString(), "Counter");
                    String key = CounterDomain.createCacheKey(resultModel.getItem().getName().toString());
                    cache.put(parentKey, key, resultModel.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
                    cache.listCacheClear(parentKey.replace("Counter", "Complete"), Complete.class);
                    break;
                }
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public static void updateCacheFromStampTask(CacheDatabase cache, String method, String request, String result) {
        try {
            switch (method) {
                case "ReceiveByUserId": {
                    ReceiveByUserIdRequest requestModel = ReceiveByUserIdRequest.fromJson(new ObjectMapper().readTree(request));
                    ReceiveByUserIdResult resultModel = ReceiveByUserIdResult.fromJson(new ObjectMapper().readTree(result));
                    String parentKey = UserDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), resultModel.getItem().getUserId().toString(), "Complete");
                    String key = CompleteDomain.createCacheKey(resultModel.getItem().getMissionGroupName().toString());
                    cache.put(parentKey, key, resultModel.getItem(), resultModel.getItem().getNextResetAt() == null ? System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes : resultModel.getItem().getNextResetAt());
                    break;
                }
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public static void updateCacheFromJobResult(CacheDatabase cache, String method, Job job, JobResultBody result) {
        try {
            switch (method) {
                case "increase_counter_by_user_id": {
                    IncreaseCounterByUserIdRequest requestModel = IncreaseCounterByUserIdRequest.fromJson(new ObjectMapper().readTree(job.getArgs()));
                    IncreaseCounterByUserIdResult resultModel = IncreaseCounterByUserIdResult.fromJson(new ObjectMapper().readTree(result.getResult()));
                    String parentKey = UserDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), resultModel.getItem().getUserId().toString(), "Counter");
                    String key = CounterDomain.createCacheKey(resultModel.getItem().getName().toString());
                    cache.put(parentKey, key, resultModel.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
                    cache.listCacheClear(parentKey.replace("Counter", "Complete"), Complete.class);
                    break;
                }
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }
}

