/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.matchmaking.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.model.IModel;
import io.gs2.matchmaking.model.Attribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Player
implements IModel,
Serializable {
    private String userId;
    private List<Attribute> attributes;
    private String roleName;
    private List<String> denyUserIds;

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Player withUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    public Player withAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
        return this;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public Player withRoleName(String roleName) {
        this.roleName = roleName;
        return this;
    }

    public List<String> getDenyUserIds() {
        return this.denyUserIds;
    }

    public void setDenyUserIds(List<String> denyUserIds) {
        this.denyUserIds = denyUserIds;
    }

    public Player withDenyUserIds(List<String> denyUserIds) {
        this.denyUserIds = denyUserIds;
        return this;
    }

    public static Player fromJson(JsonNode data) {
        if (data == null) {
            return null;
        }
        return new Player().withUserId(data.get("userId") == null || data.get("userId").isNull() ? null : data.get("userId").asText()).withAttributes(data.get("attributes") == null || data.get("attributes").isNull() ? new ArrayList<Attribute>() : StreamSupport.stream(Spliterators.spliteratorUnknownSize(data.get("attributes").elements(), 256), false).map(item -> Attribute.fromJson(item)).collect(Collectors.toList())).withRoleName(data.get("roleName") == null || data.get("roleName").isNull() ? null : data.get("roleName").asText()).withDenyUserIds(data.get("denyUserIds") == null || data.get("denyUserIds").isNull() ? new ArrayList<String>() : StreamSupport.stream(Spliterators.spliteratorUnknownSize(data.get("denyUserIds").elements(), 256), false).map(item -> item.asText()).collect(Collectors.toList()));
    }

    public JsonNode toJson() {
        return new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
            {
                this.put("userId", Player.this.getUserId());
                this.put("attributes", Player.this.getAttributes() == null ? new ArrayList() : Player.this.getAttributes().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                this.put("roleName", Player.this.getRoleName());
                this.put("denyUserIds", Player.this.getDenyUserIds() == null ? new ArrayList() : Player.this.getDenyUserIds().stream().map(item -> item).collect(Collectors.toList()));
            }
        });
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.userId == null ? 0 : this.userId.hashCode());
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.roleName == null ? 0 : this.roleName.hashCode());
        result = 31 * result + (this.denyUserIds == null ? 0 : this.denyUserIds.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Player other = (Player)o;
        if (this.userId == null) {
            return other.userId == null;
        }
        if (!this.userId.equals(other.userId)) {
            return false;
        }
        if (this.attributes == null) {
            return other.attributes == null;
        }
        if (!this.attributes.equals(other.attributes)) {
            return false;
        }
        if (this.roleName == null) {
            return other.roleName == null;
        }
        if (!this.roleName.equals(other.roleName)) {
            return false;
        }
        if (this.denyUserIds == null) {
            return other.denyUserIds == null;
        }
        return this.denyUserIds.equals(other.denyUserIds);
    }
}

