/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.matchmaking.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.matchmaking.Gs2MatchmakingRestClient;
import io.gs2.matchmaking.domain.model.UserDomain;
import io.gs2.matchmaking.model.Gathering;
import io.gs2.matchmaking.request.CancelMatchmakingByUserIdRequest;
import io.gs2.matchmaking.request.GetGatheringRequest;
import io.gs2.matchmaking.request.UpdateGatheringByUserIdRequest;
import io.gs2.matchmaking.result.CancelMatchmakingByUserIdResult;
import io.gs2.matchmaking.result.GetGatheringResult;
import io.gs2.matchmaking.result.UpdateGatheringByUserIdResult;

public class GatheringDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2MatchmakingRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String gatheringName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getGatheringName() {
        return this.gatheringName;
    }

    public GatheringDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, String gatheringName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2MatchmakingRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.gatheringName = gatheringName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "Singleton", "Gathering");
    }

    public GatheringDomain update(UpdateGatheringByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withGatheringName(this.gatheringName);
        UpdateGatheringByUserIdResult result = this.client.updateGatheringByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, GatheringDomain.createCacheKey(request.getGatheringName() != null ? request.getGatheringName().toString() : null), result.getItem(), result.getItem().getExpiresAt() == null ? System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes : result.getItem().getExpiresAt());
        }
        GatheringDomain domain = this;
        return domain;
    }

    private Gathering get(GetGatheringRequest request) {
        request.withNamespaceName(this.namespaceName).withGatheringName(this.gatheringName);
        GetGatheringResult result = this.client.getGathering(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, GatheringDomain.createCacheKey(request.getGatheringName() != null ? request.getGatheringName().toString() : null), result.getItem(), result.getItem().getExpiresAt() == null ? System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes : result.getItem().getExpiresAt());
        }
        return result.getItem();
    }

    public GatheringDomain cancelMatchmaking(CancelMatchmakingByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withGatheringName(this.gatheringName);
        CancelMatchmakingByUserIdResult result = null;
        try {
            result = this.client.cancelMatchmakingByUserId(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, GatheringDomain.createCacheKey(request.getGatheringName() != null ? request.getGatheringName().toString() : null), Gathering.class);
        GatheringDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String gatheringName, String childType) {
        return String.join((CharSequence)":", "matchmaking", namespaceName, userId, gatheringName, childType);
    }

    public static String createCacheKey(String gatheringName) {
        return String.join((CharSequence)":", gatheringName);
    }

    public Gathering model() {
        Gathering value = this.cache.get(this.parentKey, GatheringDomain.createCacheKey(this.getGatheringName() != null ? this.getGatheringName().toString() : null), Gathering.class);
        if (value == null) {
            try {
                this.get(new GetGatheringRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, GatheringDomain.createCacheKey(this.getGatheringName() != null ? this.getGatheringName().toString() : null), Gathering.class);
            }
            value = this.cache.get(this.parentKey, GatheringDomain.createCacheKey(this.getGatheringName() != null ? this.getGatheringName().toString() : null), Gathering.class);
        }
        return value;
    }
}

