/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.matchmaking.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.matchmaking.Gs2MatchmakingRestClient;
import io.gs2.matchmaking.domain.model.UserDomain;
import io.gs2.matchmaking.model.Gathering;
import io.gs2.matchmaking.model.Player;
import io.gs2.matchmaking.request.DoMatchmakingByUserIdRequest;
import io.gs2.matchmaking.result.DoMatchmakingByUserIdResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DoMatchmakingByUserIdIterator
implements Iterator<Gathering>,
Iterable<Gathering> {
    CacheDatabase cache;
    Gs2MatchmakingRestClient client;
    String namespaceName;
    String userId;
    Player player;
    String matchmakingContextToken;
    boolean last;
    List<Gathering> result;
    Integer fetchSize;

    public DoMatchmakingByUserIdIterator(CacheDatabase cache, Gs2MatchmakingRestClient client, String namespaceName, String userId, Player player) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.player = player;
        this.matchmakingContextToken = null;
        this.last = false;
        this.result = new ArrayList<Gathering>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        DoMatchmakingByUserIdResult r = this.client.doMatchmakingByUserId(new DoMatchmakingByUserIdRequest().withNamespaceName(this.namespaceName).withUserId(this.userId).withPlayer(this.player).withMatchmakingContextToken(this.matchmakingContextToken));
        this.result = new ArrayList<Gathering>();
        this.result.add(r.getItem());
        this.matchmakingContextToken = r.getMatchmakingContextToken();
        this.last = this.matchmakingContextToken == null;
        this.cache.listCacheClear(UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "Singleton", "Gathering"), Gathering.class);
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public Gathering next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        Gathering ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<Gathering> iterator() {
        return this;
    }
}

