/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.matchmaking.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.matchmaking.Gs2MatchmakingRestClient;
import io.gs2.matchmaking.domain.model.GatheringDomain;
import io.gs2.matchmaking.domain.model.UserDomain;
import io.gs2.matchmaking.model.Gathering;
import io.gs2.matchmaking.request.DescribeGatheringsRequest;
import io.gs2.matchmaking.result.DescribeGatheringsResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeGatheringsIterator
implements Iterator<Gathering>,
Iterable<Gathering> {
    CacheDatabase cache;
    Gs2MatchmakingRestClient client;
    String namespaceName;
    String pageToken;
    boolean last;
    List<Gathering> result;
    Integer fetchSize;

    public DescribeGatheringsIterator(CacheDatabase cache, Gs2MatchmakingRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<Gathering>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "Singleton", "Gathering");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, Gathering.class)) {
            this.result = this.cache.list(parentKey, Gathering.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeGatheringsResult r = this.client.describeGatherings(new DescribeGatheringsRequest().withNamespaceName(this.namespaceName).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (Gathering item : this.result) {
                this.cache.put(parentKey, GatheringDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, item.getExpiresAt() == null ? System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes : item.getExpiresAt());
            }
            if (this.last) {
                this.cache.listCached(listParentKey, Gathering.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public Gathering next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        Gathering ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<Gathering> iterator() {
        return this;
    }
}

