/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.lottery.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.lottery.Gs2LotteryRestClient;
import io.gs2.lottery.domain.iterator.DescribeBoxesByUserIdIterator;
import io.gs2.lottery.domain.iterator.DescribeProbabilitiesByUserIdIterator;
import io.gs2.lottery.domain.model.BoxDomain;
import io.gs2.lottery.domain.model.BoxItemsDomain;
import io.gs2.lottery.domain.model.LotteryDomain;
import io.gs2.lottery.domain.model.NamespaceDomain;
import io.gs2.lottery.domain.model.ProbabilityDomain;

public class UserDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2LotteryRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String parentKey;
    String nextPageToken;

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public UserDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2LotteryRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "User");
    }

    public LotteryDomain lottery() {
        return new LotteryDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId);
    }

    public BoxItemsDomain boxItems() {
        return new BoxItemsDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId);
    }

    public DescribeProbabilitiesByUserIdIterator probabilities(String lotteryName) {
        return new DescribeProbabilitiesByUserIdIterator(this.cache, this.client, this.namespaceName, lotteryName, this.userId);
    }

    public ProbabilityDomain probability() {
        return new ProbabilityDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId);
    }

    public DescribeBoxesByUserIdIterator boxes() {
        return new DescribeBoxesByUserIdIterator(this.cache, this.client, this.namespaceName, this.userId);
    }

    public BoxDomain box(String prizeTableName) {
        return new BoxDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId, prizeTableName);
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "lottery", namespaceName, userId, childType);
    }

    public static String createCacheKey(String userId) {
        return String.join((CharSequence)":", userId);
    }
}

