/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.lottery.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.lottery.Gs2LotteryRestClient;
import io.gs2.lottery.domain.iterator.DescribeBoxesIterator;
import io.gs2.lottery.domain.iterator.DescribeProbabilitiesIterator;
import io.gs2.lottery.domain.model.BoxAccessTokenDomain;
import io.gs2.lottery.domain.model.BoxItemsAccessTokenDomain;
import io.gs2.lottery.domain.model.LotteryAccessTokenDomain;
import io.gs2.lottery.domain.model.NamespaceDomain;
import io.gs2.lottery.domain.model.ProbabilityAccessTokenDomain;

public class UserAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2LotteryRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String parentKey;
    String nextPageToken;

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public UserAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2LotteryRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "User");
    }

    public LotteryAccessTokenDomain lottery() {
        return new LotteryAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.accessToken);
    }

    public BoxItemsAccessTokenDomain boxItems() {
        return new BoxItemsAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.accessToken);
    }

    public DescribeProbabilitiesIterator probabilities(String lotteryName) {
        return new DescribeProbabilitiesIterator(this.cache, this.client, this.namespaceName, lotteryName, this.accessToken);
    }

    public ProbabilityAccessTokenDomain probability() {
        return new ProbabilityAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.accessToken);
    }

    public DescribeBoxesIterator boxes() {
        return new DescribeBoxesIterator(this.cache, this.client, this.namespaceName, this.accessToken);
    }

    public BoxAccessTokenDomain box(String prizeTableName) {
        return new BoxAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.accessToken, prizeTableName);
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "lottery", namespaceName, userId, childType);
    }

    public static String createCacheKey(String userId) {
        return String.join((CharSequence)":", userId);
    }
}

