/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.lottery.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.lottery.Gs2LotteryRestClient;
import io.gs2.lottery.domain.model.ProbabilityDomain;
import io.gs2.lottery.domain.model.UserDomain;
import io.gs2.lottery.model.Probability;

public class ProbabilityAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2LotteryRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public ProbabilityAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2LotteryRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Probability");
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "lottery", namespaceName, userId, childType);
    }

    public static String createCacheKey() {
        return "Singleton";
    }

    public Probability model() {
        Probability value = this.cache.get(this.parentKey, ProbabilityDomain.createCacheKey(), Probability.class);
        return value;
    }
}

