/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.lottery.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.lottery.Gs2LotteryRestClient;
import io.gs2.lottery.domain.model.NamespaceDomain;
import io.gs2.lottery.model.PrizeTableMaster;
import io.gs2.lottery.request.DeletePrizeTableMasterRequest;
import io.gs2.lottery.request.GetPrizeTableMasterRequest;
import io.gs2.lottery.request.UpdatePrizeTableMasterRequest;
import io.gs2.lottery.result.DeletePrizeTableMasterResult;
import io.gs2.lottery.result.GetPrizeTableMasterResult;
import io.gs2.lottery.result.UpdatePrizeTableMasterResult;

public class PrizeTableMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2LotteryRestClient client;
    private final String namespaceName;
    private final String prizeTableName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getPrizeTableName() {
        return this.prizeTableName;
    }

    public PrizeTableMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String prizeTableName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2LotteryRestClient(session);
        this.namespaceName = namespaceName;
        this.prizeTableName = prizeTableName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "PrizeTableMaster");
    }

    private PrizeTableMaster get(GetPrizeTableMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withPrizeTableName(this.prizeTableName);
        GetPrizeTableMasterResult result = this.client.getPrizeTableMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, PrizeTableMasterDomain.createCacheKey(request.getPrizeTableName() != null ? request.getPrizeTableName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public PrizeTableMasterDomain update(UpdatePrizeTableMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withPrizeTableName(this.prizeTableName);
        UpdatePrizeTableMasterResult result = this.client.updatePrizeTableMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, PrizeTableMasterDomain.createCacheKey(request.getPrizeTableName() != null ? request.getPrizeTableName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        PrizeTableMasterDomain domain = this;
        return domain;
    }

    public PrizeTableMasterDomain delete(DeletePrizeTableMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withPrizeTableName(this.prizeTableName);
        DeletePrizeTableMasterResult result = null;
        try {
            result = this.client.deletePrizeTableMaster(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, PrizeTableMasterDomain.createCacheKey(request.getPrizeTableName() != null ? request.getPrizeTableName().toString() : null), PrizeTableMaster.class);
        PrizeTableMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String prizeTableName, String childType) {
        return String.join((CharSequence)":", "lottery", namespaceName, prizeTableName, childType);
    }

    public static String createCacheKey(String prizeTableName) {
        return String.join((CharSequence)":", prizeTableName);
    }

    public PrizeTableMaster model() {
        PrizeTableMaster value = this.cache.get(this.parentKey, PrizeTableMasterDomain.createCacheKey(this.getPrizeTableName() != null ? this.getPrizeTableName().toString() : null), PrizeTableMaster.class);
        if (value == null) {
            try {
                this.get(new GetPrizeTableMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, PrizeTableMasterDomain.createCacheKey(this.getPrizeTableName() != null ? this.getPrizeTableName().toString() : null), PrizeTableMaster.class);
            }
            value = this.cache.get(this.parentKey, PrizeTableMasterDomain.createCacheKey(this.getPrizeTableName() != null ? this.getPrizeTableName().toString() : null), PrizeTableMaster.class);
        }
        return value;
    }
}

