/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.lottery.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.lottery.Gs2LotteryRestClient;
import io.gs2.lottery.domain.model.NamespaceDomain;
import io.gs2.lottery.model.CurrentLotteryMaster;
import io.gs2.lottery.request.ExportMasterRequest;
import io.gs2.lottery.request.GetCurrentLotteryMasterRequest;
import io.gs2.lottery.request.UpdateCurrentLotteryMasterFromGitHubRequest;
import io.gs2.lottery.request.UpdateCurrentLotteryMasterRequest;
import io.gs2.lottery.result.ExportMasterResult;
import io.gs2.lottery.result.GetCurrentLotteryMasterResult;
import io.gs2.lottery.result.UpdateCurrentLotteryMasterFromGitHubResult;
import io.gs2.lottery.result.UpdateCurrentLotteryMasterResult;

public class CurrentLotteryMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2LotteryRestClient client;
    private final String namespaceName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public CurrentLotteryMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2LotteryRestClient(session);
        this.namespaceName = namespaceName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "CurrentLotteryMaster");
    }

    public CurrentLotteryMasterDomain exportMaster(ExportMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        ExportMasterResult result = this.client.exportMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentLotteryMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentLotteryMasterDomain domain = this;
        return domain;
    }

    private CurrentLotteryMaster get(GetCurrentLotteryMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        GetCurrentLotteryMasterResult result = this.client.getCurrentLotteryMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentLotteryMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public CurrentLotteryMasterDomain update(UpdateCurrentLotteryMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateCurrentLotteryMasterResult result = this.client.updateCurrentLotteryMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentLotteryMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentLotteryMasterDomain domain = this;
        return domain;
    }

    public CurrentLotteryMasterDomain updateFromGitHub(UpdateCurrentLotteryMasterFromGitHubRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateCurrentLotteryMasterFromGitHubResult result = this.client.updateCurrentLotteryMasterFromGitHub(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentLotteryMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentLotteryMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String childType) {
        return String.join((CharSequence)":", "lottery", namespaceName, childType);
    }

    public static String createCacheKey(String namespaceName) {
        return String.join((CharSequence)":", namespaceName);
    }

    public CurrentLotteryMaster model() {
        CurrentLotteryMaster value = this.cache.get(this.parentKey, CurrentLotteryMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentLotteryMaster.class);
        if (value == null) {
            try {
                this.get(new GetCurrentLotteryMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, CurrentLotteryMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentLotteryMaster.class);
            }
            value = this.cache.get(this.parentKey, CurrentLotteryMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentLotteryMaster.class);
        }
        return value;
    }
}

