/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.lottery.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.lottery.Gs2LotteryRestClient;
import io.gs2.lottery.domain.model.BoxItemsDomain;
import io.gs2.lottery.domain.model.UserDomain;
import io.gs2.lottery.model.Box;
import io.gs2.lottery.model.BoxItems;
import io.gs2.lottery.request.GetBoxByUserIdRequest;
import io.gs2.lottery.request.GetRawBoxByUserIdRequest;
import io.gs2.lottery.request.ResetBoxByUserIdRequest;
import io.gs2.lottery.result.GetBoxByUserIdResult;
import io.gs2.lottery.result.GetRawBoxByUserIdResult;
import io.gs2.lottery.result.ResetBoxByUserIdResult;

public class BoxDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2LotteryRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String prizeTableName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPrizeTableName() {
        return this.prizeTableName;
    }

    public BoxDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, String prizeTableName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2LotteryRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.prizeTableName = prizeTableName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Box");
    }

    private BoxItems get(GetBoxByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withPrizeTableName(this.prizeTableName);
        GetBoxByUserIdResult result = this.client.getBoxByUserId(request);
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "BoxItems");
        if (result.getItem() != null) {
            this.cache.put(parentKey, BoxItemsDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public BoxDomain getRaw(GetRawBoxByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withPrizeTableName(this.prizeTableName);
        GetRawBoxByUserIdResult result = this.client.getRawBoxByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, BoxDomain.createCacheKey(request.getPrizeTableName() != null ? request.getPrizeTableName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        BoxDomain domain = this;
        return domain;
    }

    public BoxDomain reset(ResetBoxByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withPrizeTableName(this.prizeTableName);
        ResetBoxByUserIdResult result = this.client.resetBoxByUserId(request);
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Box");
        for (Box item : this.cache.list(parentKey, Box.class)) {
            this.cache.delete(parentKey, BoxDomain.createCacheKey(request.getPrizeTableName() != null ? request.getPrizeTableName().toString() : null), Box.class);
        }
        BoxDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String prizeTableName, String childType) {
        return String.join((CharSequence)":", "lottery", namespaceName, userId, prizeTableName, childType);
    }

    public static String createCacheKey(String prizeTableName) {
        return String.join((CharSequence)":", prizeTableName);
    }

    public BoxItems model() {
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "BoxItems");
        BoxItems value = this.cache.get(parentKey, BoxItemsDomain.createCacheKey(), BoxItems.class);
        if (value == null) {
            try {
                this.get(new GetBoxByUserIdRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(parentKey, BoxItemsDomain.createCacheKey(), BoxItems.class);
            }
            value = this.cache.get(parentKey, BoxItemsDomain.createCacheKey(), BoxItems.class);
        }
        return value;
    }
}

