/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.lottery.domain.iterator;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.lottery.Gs2LotteryRestClient;
import io.gs2.lottery.domain.model.ProbabilityDomain;
import io.gs2.lottery.domain.model.UserDomain;
import io.gs2.lottery.model.Probability;
import io.gs2.lottery.request.DescribeProbabilitiesRequest;
import io.gs2.lottery.result.DescribeProbabilitiesResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeProbabilitiesIterator
implements Iterator<Probability>,
Iterable<Probability> {
    CacheDatabase cache;
    Gs2LotteryRestClient client;
    String namespaceName;
    String lotteryName;
    AccessToken accessToken;
    boolean last;
    List<Probability> result;
    Integer fetchSize;

    public DescribeProbabilitiesIterator(CacheDatabase cache, Gs2LotteryRestClient client, String namespaceName, String lotteryName, AccessToken accessToken) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.lotteryName = lotteryName;
        this.accessToken = accessToken;
        this.last = false;
        this.result = new ArrayList<Probability>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Probability");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, Probability.class)) {
            this.result = this.cache.list(listParentKey, Probability.class).stream().collect(Collectors.toList());
            this.last = true;
        } else {
            DescribeProbabilitiesResult r = this.client.describeProbabilities(new DescribeProbabilitiesRequest().withNamespaceName(this.namespaceName).withLotteryName(this.lotteryName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null));
            this.result = r.getItems();
            this.last = true;
            for (Probability item : this.result) {
                this.cache.put(listParentKey, ProbabilityDomain.createCacheKey(), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, Probability.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public Probability next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        Probability ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<Probability> iterator() {
        return this;
    }
}

