/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.lottery.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.lottery.Gs2LotteryRestClient;
import io.gs2.lottery.domain.model.ProbabilityDomain;
import io.gs2.lottery.domain.model.UserDomain;
import io.gs2.lottery.model.Probability;
import io.gs2.lottery.request.DescribeProbabilitiesByUserIdRequest;
import io.gs2.lottery.result.DescribeProbabilitiesByUserIdResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeProbabilitiesByUserIdIterator
implements Iterator<Probability>,
Iterable<Probability> {
    CacheDatabase cache;
    Gs2LotteryRestClient client;
    String namespaceName;
    String lotteryName;
    String userId;
    boolean last;
    List<Probability> result;
    Integer fetchSize;

    public DescribeProbabilitiesByUserIdIterator(CacheDatabase cache, Gs2LotteryRestClient client, String namespaceName, String lotteryName, String userId) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.lotteryName = lotteryName;
        this.userId = userId;
        this.last = false;
        this.result = new ArrayList<Probability>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Probability");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, Probability.class)) {
            this.result = this.cache.list(listParentKey, Probability.class).stream().collect(Collectors.toList());
            this.last = true;
        } else {
            DescribeProbabilitiesByUserIdResult r = this.client.describeProbabilitiesByUserId(new DescribeProbabilitiesByUserIdRequest().withNamespaceName(this.namespaceName).withLotteryName(this.lotteryName).withUserId(this.userId));
            this.result = r.getItems();
            this.last = true;
            for (Probability item : this.result) {
                this.cache.put(listParentKey, ProbabilityDomain.createCacheKey(), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, Probability.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public Probability next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        Probability ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<Probability> iterator() {
        return this;
    }
}

