/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.lottery.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.lottery.Gs2LotteryRestClient;
import io.gs2.lottery.domain.model.NamespaceDomain;
import io.gs2.lottery.domain.model.PrizeTableDomain;
import io.gs2.lottery.model.PrizeTable;
import io.gs2.lottery.request.DescribePrizeTablesRequest;
import io.gs2.lottery.result.DescribePrizeTablesResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribePrizeTablesIterator
implements Iterator<PrizeTable>,
Iterable<PrizeTable> {
    CacheDatabase cache;
    Gs2LotteryRestClient client;
    String namespaceName;
    boolean last;
    List<PrizeTable> result;
    Integer fetchSize;

    public DescribePrizeTablesIterator(CacheDatabase cache, Gs2LotteryRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.last = false;
        this.result = new ArrayList<PrizeTable>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "PrizeTable");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, PrizeTable.class)) {
            this.result = this.cache.list(parentKey, PrizeTable.class).stream().collect(Collectors.toList());
            this.last = true;
        } else {
            DescribePrizeTablesResult r = this.client.describePrizeTables(new DescribePrizeTablesRequest().withNamespaceName(this.namespaceName));
            this.result = r.getItems();
            this.last = true;
            for (PrizeTable item : this.result) {
                this.cache.put(parentKey, PrizeTableDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, PrizeTable.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public PrizeTable next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        PrizeTable ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<PrizeTable> iterator() {
        return this;
    }
}

