/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.lottery.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.lottery.Gs2LotteryRestClient;
import io.gs2.lottery.domain.model.NamespaceDomain;
import io.gs2.lottery.domain.model.PrizeTableMasterDomain;
import io.gs2.lottery.model.PrizeTableMaster;
import io.gs2.lottery.request.DescribePrizeTableMastersRequest;
import io.gs2.lottery.result.DescribePrizeTableMastersResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribePrizeTableMastersIterator
implements Iterator<PrizeTableMaster>,
Iterable<PrizeTableMaster> {
    CacheDatabase cache;
    Gs2LotteryRestClient client;
    String namespaceName;
    String pageToken;
    boolean last;
    List<PrizeTableMaster> result;
    Integer fetchSize;

    public DescribePrizeTableMastersIterator(CacheDatabase cache, Gs2LotteryRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<PrizeTableMaster>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "PrizeTableMaster");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, PrizeTableMaster.class)) {
            this.result = this.cache.list(parentKey, PrizeTableMaster.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribePrizeTableMastersResult r = this.client.describePrizeTableMasters(new DescribePrizeTableMastersRequest().withNamespaceName(this.namespaceName).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (PrizeTableMaster item : this.result) {
                this.cache.put(parentKey, PrizeTableMasterDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, PrizeTableMaster.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public PrizeTableMaster next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        PrizeTableMaster ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<PrizeTableMaster> iterator() {
        return this;
    }
}

