/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.lottery.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.lottery.Gs2LotteryRestClient;
import io.gs2.lottery.domain.model.LotteryModelDomain;
import io.gs2.lottery.domain.model.NamespaceDomain;
import io.gs2.lottery.model.LotteryModel;
import io.gs2.lottery.request.DescribeLotteryModelsRequest;
import io.gs2.lottery.result.DescribeLotteryModelsResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeLotteryModelsIterator
implements Iterator<LotteryModel>,
Iterable<LotteryModel> {
    CacheDatabase cache;
    Gs2LotteryRestClient client;
    String namespaceName;
    boolean last;
    List<LotteryModel> result;
    Integer fetchSize;

    public DescribeLotteryModelsIterator(CacheDatabase cache, Gs2LotteryRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.last = false;
        this.result = new ArrayList<LotteryModel>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "LotteryModel");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, LotteryModel.class)) {
            this.result = this.cache.list(parentKey, LotteryModel.class).stream().collect(Collectors.toList());
            this.last = true;
        } else {
            DescribeLotteryModelsResult r = this.client.describeLotteryModels(new DescribeLotteryModelsRequest().withNamespaceName(this.namespaceName));
            this.result = r.getItems();
            this.last = true;
            for (LotteryModel item : this.result) {
                this.cache.put(parentKey, LotteryModelDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, LotteryModel.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public LotteryModel next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        LotteryModel ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<LotteryModel> iterator() {
        return this;
    }
}

