/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.lottery.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.lottery.Gs2LotteryRestClient;
import io.gs2.lottery.domain.model.LotteryModelMasterDomain;
import io.gs2.lottery.domain.model.NamespaceDomain;
import io.gs2.lottery.model.LotteryModelMaster;
import io.gs2.lottery.request.DescribeLotteryModelMastersRequest;
import io.gs2.lottery.result.DescribeLotteryModelMastersResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeLotteryModelMastersIterator
implements Iterator<LotteryModelMaster>,
Iterable<LotteryModelMaster> {
    CacheDatabase cache;
    Gs2LotteryRestClient client;
    String namespaceName;
    String pageToken;
    boolean last;
    List<LotteryModelMaster> result;
    Integer fetchSize;

    public DescribeLotteryModelMastersIterator(CacheDatabase cache, Gs2LotteryRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<LotteryModelMaster>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "LotteryModelMaster");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, LotteryModelMaster.class)) {
            this.result = this.cache.list(parentKey, LotteryModelMaster.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeLotteryModelMastersResult r = this.client.describeLotteryModelMasters(new DescribeLotteryModelMastersRequest().withNamespaceName(this.namespaceName).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (LotteryModelMaster item : this.result) {
                this.cache.put(parentKey, LotteryModelMasterDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, LotteryModelMaster.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public LotteryModelMaster next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        LotteryModelMaster ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<LotteryModelMaster> iterator() {
        return this;
    }
}

