/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.log.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.log.Gs2LogRestClient;
import io.gs2.log.domain.model.ExecuteStampSheetLogDomain;
import io.gs2.log.domain.model.NamespaceDomain;
import io.gs2.log.model.ExecuteStampSheetLog;
import io.gs2.log.request.QueryExecuteStampSheetLogRequest;
import io.gs2.log.result.QueryExecuteStampSheetLogResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class QueryExecuteStampSheetLogIterator
implements Iterator<ExecuteStampSheetLog>,
Iterable<ExecuteStampSheetLog> {
    CacheDatabase cache;
    Gs2LogRestClient client;
    String namespaceName;
    String service;
    String method;
    String userId;
    String action;
    Long begin;
    Long end;
    Boolean longTerm;
    String pageToken;
    boolean last;
    List<ExecuteStampSheetLog> result;
    Integer fetchSize;

    public QueryExecuteStampSheetLogIterator(CacheDatabase cache, Gs2LogRestClient client, String namespaceName, String service, String method, String userId, String action, Long begin, Long end, Boolean longTerm) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.service = service;
        this.method = method;
        this.userId = userId;
        this.action = action;
        this.begin = begin;
        this.end = end;
        this.longTerm = longTerm;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<ExecuteStampSheetLog>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "ExecuteStampSheetLog");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, ExecuteStampSheetLog.class)) {
            this.result = this.cache.list(parentKey, ExecuteStampSheetLog.class).stream().filter(item -> this.service == null || item.getService().equals(this.service)).filter(item -> this.method == null || item.getMethod().equals(this.method)).filter(item -> this.userId == null || item.getUserId().equals(this.userId)).filter(item -> this.action == null || item.getAction().equals(this.action)).filter(item -> this.begin == null || item.getTimestamp() >= this.begin).filter(item -> this.end == null || item.getTimestamp() <= this.end).collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            QueryExecuteStampSheetLogResult r = this.client.queryExecuteStampSheetLog(new QueryExecuteStampSheetLogRequest().withNamespaceName(this.namespaceName).withService(this.service).withMethod(this.method).withUserId(this.userId).withAction(this.action).withBegin(this.begin).withEnd(this.end).withLongTerm(this.longTerm).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (ExecuteStampSheetLog item2 : this.result) {
                this.cache.put(parentKey, ExecuteStampSheetLogDomain.createCacheKey(), item2, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, ExecuteStampSheetLog.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public ExecuteStampSheetLog next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        ExecuteStampSheetLog ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<ExecuteStampSheetLog> iterator() {
        return this;
    }
}

