/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.log.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.log.Gs2LogRestClient;
import io.gs2.log.model.AccessLogCount;
import io.gs2.log.request.CountAccessLogRequest;
import io.gs2.log.result.CountAccessLogResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CountAccessLogIterator
implements Iterator<AccessLogCount>,
Iterable<AccessLogCount> {
    CacheDatabase cache;
    Gs2LogRestClient client;
    String namespaceName;
    Boolean service;
    Boolean method;
    Boolean userId;
    Long begin;
    Long end;
    Boolean longTerm;
    String pageToken;
    boolean last;
    List<AccessLogCount> result;
    Integer fetchSize;

    public CountAccessLogIterator(CacheDatabase cache, Gs2LogRestClient client, String namespaceName, Boolean service, Boolean method, Boolean userId, Long begin, Long end, Boolean longTerm) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.service = service;
        this.method = method;
        this.userId = userId;
        this.begin = begin;
        this.end = end;
        this.longTerm = longTerm;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<AccessLogCount>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        CountAccessLogResult r = this.client.countAccessLog(new CountAccessLogRequest().withNamespaceName(this.namespaceName).withService(this.service).withMethod(this.method).withUserId(this.userId).withBegin(this.begin).withEnd(this.end).withLongTerm(this.longTerm).withPageToken(this.pageToken).withLimit(this.fetchSize));
        this.result = r.getItems();
        this.pageToken = r.getNextPageToken();
        this.last = this.pageToken == null;
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public AccessLogCount next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        AccessLogCount ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<AccessLogCount> iterator() {
        return this;
    }
}

