/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.lock.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.lock.Gs2LockRestClient;
import io.gs2.lock.domain.model.UserAccessTokenDomain;
import io.gs2.lock.domain.model.UserDomain;
import io.gs2.lock.model.Namespace;
import io.gs2.lock.request.DeleteNamespaceRequest;
import io.gs2.lock.request.GetNamespaceRequest;
import io.gs2.lock.request.GetNamespaceStatusRequest;
import io.gs2.lock.request.UpdateNamespaceRequest;
import io.gs2.lock.result.DeleteNamespaceResult;
import io.gs2.lock.result.GetNamespaceResult;
import io.gs2.lock.result.GetNamespaceStatusResult;
import io.gs2.lock.result.UpdateNamespaceResult;

public class NamespaceDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2LockRestClient client;
    private final String namespaceName;
    private final String parentKey;
    String status;

    public String getStatus() {
        return this.status;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public NamespaceDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2LockRestClient(session);
        this.namespaceName = namespaceName;
        this.parentKey = "lock:Namespace";
    }

    public NamespaceDomain getStatus(GetNamespaceStatusRequest request) {
        request.withNamespaceName(this.namespaceName);
        GetNamespaceStatusResult result = this.client.getNamespaceStatus(request);
        NamespaceDomain domain = this;
        this.status = result.getStatus();
        return domain;
    }

    private Namespace get(GetNamespaceRequest request) {
        request.withNamespaceName(this.namespaceName);
        GetNamespaceResult result = this.client.getNamespace(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, NamespaceDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public NamespaceDomain update(UpdateNamespaceRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateNamespaceResult result = this.client.updateNamespace(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, NamespaceDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        NamespaceDomain domain = this;
        return domain;
    }

    public NamespaceDomain delete(DeleteNamespaceRequest request) {
        request.withNamespaceName(this.namespaceName);
        DeleteNamespaceResult result = null;
        try {
            result = this.client.deleteNamespace(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, NamespaceDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), Namespace.class);
        NamespaceDomain domain = this;
        return domain;
    }

    public UserDomain user(String userId) {
        return new UserDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, userId);
    }

    public UserAccessTokenDomain accessToken(AccessToken accessToken) {
        return new UserAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, accessToken);
    }

    public static String createCacheParentKey(String namespaceName, String childType) {
        return String.join((CharSequence)":", "lock", namespaceName, childType);
    }

    public static String createCacheKey(String namespaceName) {
        return String.join((CharSequence)":", namespaceName);
    }

    public Namespace model() {
        Namespace value = this.cache.get(this.parentKey, NamespaceDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), Namespace.class);
        if (value == null) {
            try {
                this.get(new GetNamespaceRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, NamespaceDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), Namespace.class);
            }
            value = this.cache.get(this.parentKey, NamespaceDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), Namespace.class);
        }
        return value;
    }
}

