/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.lock.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.lock.Gs2LockRestClient;
import io.gs2.lock.domain.model.UserDomain;
import io.gs2.lock.model.Mutex;
import io.gs2.lock.request.DeleteMutexByUserIdRequest;
import io.gs2.lock.request.GetMutexByUserIdRequest;
import io.gs2.lock.request.LockByUserIdRequest;
import io.gs2.lock.request.UnlockByUserIdRequest;
import io.gs2.lock.result.DeleteMutexByUserIdResult;
import io.gs2.lock.result.GetMutexByUserIdResult;
import io.gs2.lock.result.LockByUserIdResult;
import io.gs2.lock.result.UnlockByUserIdResult;

public class MutexDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2LockRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String propertyId;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPropertyId() {
        return this.propertyId;
    }

    public MutexDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, String propertyId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2LockRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.propertyId = propertyId;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Mutex");
    }

    public MutexDomain lock(LockByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withPropertyId(this.propertyId);
        LockByUserIdResult result = this.client.lockByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, MutexDomain.createCacheKey(request.getPropertyId() != null ? request.getPropertyId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        MutexDomain domain = this;
        return domain;
    }

    public MutexDomain unlock(UnlockByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withPropertyId(this.propertyId);
        UnlockByUserIdResult result = this.client.unlockByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, MutexDomain.createCacheKey(request.getPropertyId() != null ? request.getPropertyId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        MutexDomain domain = this;
        return domain;
    }

    private Mutex get(GetMutexByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withPropertyId(this.propertyId);
        GetMutexByUserIdResult result = this.client.getMutexByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, MutexDomain.createCacheKey(request.getPropertyId() != null ? request.getPropertyId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public MutexDomain delete(DeleteMutexByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withPropertyId(this.propertyId);
        DeleteMutexByUserIdResult result = null;
        try {
            result = this.client.deleteMutexByUserId(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, MutexDomain.createCacheKey(request.getPropertyId() != null ? request.getPropertyId().toString() : null), Mutex.class);
        MutexDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String propertyId, String childType) {
        return String.join((CharSequence)":", "lock", namespaceName, userId, propertyId, childType);
    }

    public static String createCacheKey(String propertyId) {
        return String.join((CharSequence)":", propertyId);
    }

    public Mutex model() {
        Mutex value = this.cache.get(this.parentKey, MutexDomain.createCacheKey(this.getPropertyId() != null ? this.getPropertyId().toString() : null), Mutex.class);
        if (value == null) {
            try {
                this.get(new GetMutexByUserIdRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, MutexDomain.createCacheKey(this.getPropertyId() != null ? this.getPropertyId().toString() : null), Mutex.class);
            }
            value = this.cache.get(this.parentKey, MutexDomain.createCacheKey(this.getPropertyId() != null ? this.getPropertyId().toString() : null), Mutex.class);
        }
        return value;
    }
}

