/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.lock.domain.iterator;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.lock.Gs2LockRestClient;
import io.gs2.lock.domain.model.MutexDomain;
import io.gs2.lock.domain.model.UserDomain;
import io.gs2.lock.model.Mutex;
import io.gs2.lock.request.DescribeMutexesRequest;
import io.gs2.lock.result.DescribeMutexesResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeMutexesIterator
implements Iterator<Mutex>,
Iterable<Mutex> {
    CacheDatabase cache;
    Gs2LockRestClient client;
    String namespaceName;
    AccessToken accessToken;
    String pageToken;
    boolean last;
    List<Mutex> result;
    Integer fetchSize;

    public DescribeMutexesIterator(CacheDatabase cache, Gs2LockRestClient client, String namespaceName, AccessToken accessToken) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<Mutex>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Mutex");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, Mutex.class)) {
            this.result = this.cache.list(parentKey, Mutex.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeMutexesResult r = this.client.describeMutexes(new DescribeMutexesRequest().withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (Mutex item : this.result) {
                this.cache.put(parentKey, MutexDomain.createCacheKey(item.getPropertyId() != null ? item.getPropertyId().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, Mutex.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public Mutex next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        Mutex ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<Mutex> iterator() {
        return this;
    }
}

