/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.lock.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.lock.Gs2LockRestClient;
import io.gs2.lock.domain.model.MutexDomain;
import io.gs2.lock.domain.model.UserDomain;
import io.gs2.lock.model.Mutex;
import io.gs2.lock.request.DescribeMutexesByUserIdRequest;
import io.gs2.lock.result.DescribeMutexesByUserIdResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeMutexesByUserIdIterator
implements Iterator<Mutex>,
Iterable<Mutex> {
    CacheDatabase cache;
    Gs2LockRestClient client;
    String namespaceName;
    String userId;
    String pageToken;
    boolean last;
    List<Mutex> result;
    Integer fetchSize;

    public DescribeMutexesByUserIdIterator(CacheDatabase cache, Gs2LockRestClient client, String namespaceName, String userId) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<Mutex>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Mutex");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, Mutex.class)) {
            this.result = this.cache.list(parentKey, Mutex.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeMutexesByUserIdResult r = this.client.describeMutexesByUserId(new DescribeMutexesByUserIdRequest().withNamespaceName(this.namespaceName).withUserId(this.userId).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (Mutex item : this.result) {
                this.cache.put(parentKey, MutexDomain.createCacheKey(item.getPropertyId() != null ? item.getPropertyId().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, Mutex.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public Mutex next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        Mutex ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<Mutex> iterator() {
        return this;
    }
}

