/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.limit.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.limit.Gs2LimitRestClient;
import io.gs2.limit.domain.model.LimitModelDomain;
import io.gs2.limit.domain.model.NamespaceDomain;
import io.gs2.limit.model.LimitModel;
import io.gs2.limit.request.DescribeLimitModelsRequest;
import io.gs2.limit.result.DescribeLimitModelsResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeLimitModelsIterator
implements Iterator<LimitModel>,
Iterable<LimitModel> {
    CacheDatabase cache;
    Gs2LimitRestClient client;
    String namespaceName;
    boolean last;
    List<LimitModel> result;
    Integer fetchSize;

    public DescribeLimitModelsIterator(CacheDatabase cache, Gs2LimitRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.last = false;
        this.result = new ArrayList<LimitModel>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "LimitModel");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, LimitModel.class)) {
            this.result = this.cache.list(parentKey, LimitModel.class).stream().collect(Collectors.toList());
            this.last = true;
        } else {
            DescribeLimitModelsResult r = this.client.describeLimitModels(new DescribeLimitModelsRequest().withNamespaceName(this.namespaceName));
            this.result = r.getItems();
            this.last = true;
            for (LimitModel item : this.result) {
                this.cache.put(parentKey, LimitModelDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, LimitModel.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public LimitModel next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        LimitModel ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<LimitModel> iterator() {
        return this;
    }
}

