/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.key.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.key.Gs2KeyRestClient;
import io.gs2.key.domain.model.NamespaceDomain;
import io.gs2.key.model.GitHubApiKey;
import io.gs2.key.request.DeleteGitHubApiKeyRequest;
import io.gs2.key.request.GetGitHubApiKeyRequest;
import io.gs2.key.request.UpdateGitHubApiKeyRequest;
import io.gs2.key.result.DeleteGitHubApiKeyResult;
import io.gs2.key.result.GetGitHubApiKeyResult;
import io.gs2.key.result.UpdateGitHubApiKeyResult;

public class GitHubApiKeyDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2KeyRestClient client;
    private final String namespaceName;
    private final String apiKeyName;
    private final String parentKey;
    String apiKey;

    public String getApiKey() {
        return this.apiKey;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getApiKeyName() {
        return this.apiKeyName;
    }

    public GitHubApiKeyDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String apiKeyName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2KeyRestClient(session);
        this.namespaceName = namespaceName;
        this.apiKeyName = apiKeyName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "GitHubApiKey");
    }

    public GitHubApiKeyDomain update(UpdateGitHubApiKeyRequest request) {
        request.withNamespaceName(this.namespaceName).withApiKeyName(this.apiKeyName);
        UpdateGitHubApiKeyResult result = this.client.updateGitHubApiKey(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, GitHubApiKeyDomain.createCacheKey(request.getApiKeyName() != null ? request.getApiKeyName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        GitHubApiKeyDomain domain = this;
        return domain;
    }

    private GitHubApiKey get(GetGitHubApiKeyRequest request) {
        request.withNamespaceName(this.namespaceName).withApiKeyName(this.apiKeyName);
        GetGitHubApiKeyResult result = this.client.getGitHubApiKey(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, GitHubApiKeyDomain.createCacheKey(request.getApiKeyName() != null ? request.getApiKeyName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public GitHubApiKeyDomain delete(DeleteGitHubApiKeyRequest request) {
        request.withNamespaceName(this.namespaceName).withApiKeyName(this.apiKeyName);
        DeleteGitHubApiKeyResult result = null;
        try {
            result = this.client.deleteGitHubApiKey(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, GitHubApiKeyDomain.createCacheKey(request.getApiKeyName() != null ? request.getApiKeyName().toString() : null), GitHubApiKey.class);
        GitHubApiKeyDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String apiKeyName, String childType) {
        return String.join((CharSequence)":", "key", namespaceName, apiKeyName, childType);
    }

    public static String createCacheKey(String apiKeyName) {
        return String.join((CharSequence)":", apiKeyName);
    }

    public GitHubApiKey model() {
        GitHubApiKey value = this.cache.get(this.parentKey, GitHubApiKeyDomain.createCacheKey(this.getApiKeyName() != null ? this.getApiKeyName().toString() : null), GitHubApiKey.class);
        if (value == null) {
            try {
                this.get(new GetGitHubApiKeyRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, GitHubApiKeyDomain.createCacheKey(this.getApiKeyName() != null ? this.getApiKeyName().toString() : null), GitHubApiKey.class);
            }
            value = this.cache.get(this.parentKey, GitHubApiKeyDomain.createCacheKey(this.getApiKeyName() != null ? this.getApiKeyName().toString() : null), GitHubApiKey.class);
        }
        return value;
    }
}

