/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.jobQueue.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.jobQueue.Gs2JobQueueRestClient;
import io.gs2.jobQueue.domain.model.DeadLetterJobAccessTokenDomain;
import io.gs2.jobQueue.domain.model.JobAccessTokenDomain;
import io.gs2.jobQueue.domain.model.JobDomain;
import io.gs2.jobQueue.domain.model.NamespaceDomain;
import io.gs2.jobQueue.domain.model.UserDomain;
import io.gs2.jobQueue.model.Job;
import io.gs2.jobQueue.request.RunRequest;
import io.gs2.jobQueue.result.RunResult;

public class UserAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2JobQueueRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String parentKey;
    Boolean isLastJob;
    String nextPageToken;

    public Boolean getIsLastJob() {
        return this.isLastJob;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public UserAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2JobQueueRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "User");
    }

    public JobAccessTokenDomain run(RunRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null);
        RunResult result = null;
        try {
            result = this.client.run(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Job");
        this.cache.delete(parentKey, JobDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null), Job.class);
        if (result.getItem() != null) {
            Gs2.updateCacheFromJobResult(this.cache, result.getItem(), result.getResult());
        }
        JobAccessTokenDomain domain = new JobAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), this.accessToken, result.getItem().getName());
        domain.isLastJob = result.getIsLastJob();
        return domain;
    }

    public JobAccessTokenDomain job(String jobName) {
        return new JobAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.accessToken, jobName);
    }

    public DeadLetterJobAccessTokenDomain deadLetterJob(String deadLetterJobName) {
        return new DeadLetterJobAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.accessToken, deadLetterJobName);
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "jobQueue", namespaceName, userId, childType);
    }

    public static String createCacheKey(String userId) {
        return String.join((CharSequence)":", userId);
    }
}

