/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.jobQueue.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.jobQueue.Gs2JobQueueRestClient;
import io.gs2.jobQueue.domain.model.JobDomain;
import io.gs2.jobQueue.model.JobResult;

public class JobResultDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2JobQueueRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String jobName;
    private final String tryNumber;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getTryNumber() {
        return this.tryNumber;
    }

    public JobResultDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, String jobName, String tryNumber) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2JobQueueRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.jobName = jobName;
        this.tryNumber = tryNumber;
        this.parentKey = JobDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, this.jobName != null ? this.jobName.toString() : null, "JobResult");
    }

    public static String createCacheParentKey(String namespaceName, String userId, String jobName, String tryNumber, String childType) {
        return String.join((CharSequence)":", "jobQueue", namespaceName, userId, jobName, tryNumber, childType);
    }

    public static String createCacheKey(String tryNumber) {
        return String.join((CharSequence)":", tryNumber);
    }

    public JobResult model() {
        JobResult value = this.cache.get(this.parentKey, JobResultDomain.createCacheKey(this.getTryNumber() != null ? this.getTryNumber().toString() : null), JobResult.class);
        return value;
    }
}

